/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs.sssp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.automatalib.commons.smartcollections.BinaryHeap;
import net.automatalib.commons.smartcollections.ElementReference;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.concepts.EdgeWeights;
import net.automatalib.util.graphs.sssp.SSSPResult;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

public class DijkstraSSSP<N, E>
implements SSSPResult<N, E> {
    private final Graph<N, E> graph;
    private final N init;
    private final EdgeWeights<E> edgeWeights;
    private final MutableMapping<N, @Nullable Record<N, E>> records;

    public DijkstraSSSP(Graph<N, E> graph, N init, EdgeWeights<E> edgeWeights) {
        this.graph = graph;
        this.init = init;
        this.edgeWeights = edgeWeights;
        this.records = graph.createStaticNodeMapping();
    }

    public static <N, E> SSSPResult<N, E> findSSSP(Graph<N, E> graph, N init, EdgeWeights<E> edgeWeights) {
        DijkstraSSSP<N, E> dijkstra = new DijkstraSSSP<N, E>(graph, init, edgeWeights);
        dijkstra.findSSSP();
        return dijkstra;
    }

    public void findSSSP() {
        Record initRec = new Record(this.init, 0.0f);
        if (this.records.put(this.init, initRec) != null) {
            throw new IllegalStateException("Search has already been performed!");
        }
        BinaryHeap pq = BinaryHeap.create(this.graph.size());
        initRec.ref = pq.referencedAdd(initRec);
        while (!pq.isEmpty()) {
            Record rec = (Record)pq.extractMin();
            float dist = rec.dist;
            Object node = rec.node;
            for (Object edge : this.graph.getOutgoingEdges(node)) {
                float w = this.edgeWeights.getEdgeWeight(edge);
                float newDist = dist + w;
                Object tgt = this.graph.getTarget(edge);
                Record tgtRec = (Record)this.records.get(tgt);
                if (tgtRec == null) {
                    tgtRec = new Record(tgt, newDist, edge, rec);
                    tgtRec.ref = pq.referencedAdd(tgtRec);
                    this.records.put(tgt, tgtRec);
                    continue;
                }
                if (!(newDist < tgtRec.dist)) continue;
                tgtRec.dist = newDist;
                tgtRec.reach = edge;
                tgtRec.depth = rec.depth + 1;
                tgtRec.parent = rec;
                pq.keyChanged(tgtRec.ref);
            }
        }
    }

    @Override
    public N getInitialNode() {
        return this.init;
    }

    @Override
    public float getShortestPathDistance(N target) {
        Record rec = (Record)this.records.get(target);
        if (rec == null) {
            return Float.NEGATIVE_INFINITY;
        }
        return rec.dist;
    }

    @Override
    public @Nullable List<E> getShortestPath(N target) {
        Object edge;
        Record rec = (Record)this.records.get(target);
        if (rec == null) {
            return null;
        }
        if (rec.depth == 0) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(rec.depth);
        while ((edge = rec.reach) != null) {
            result.add(edge);
            rec = rec.parent;
            assert (rec != null);
        }
        Collections.reverse(result);
        return result;
    }

    @Override
    public @Nullable E getShortestPathEdge(N target) {
        Record rec = (Record)this.records.get(target);
        if (rec == null) {
            return null;
        }
        return rec.reach;
    }

    private static final class Record<N, E>
    implements Comparable<Record<N, E>> {
        public final N node;
        public float dist;
        public @Nullable ElementReference ref;
        public @PolyNull E reach;
        public @PolyNull Record<N, E> parent;
        int depth;

        Record(N node, float dist) {
            this(node, dist, null, null);
        }

        Record(N node, float dist, @PolyNull E reach, @PolyNull Record<N, E> parent) {
            this.node = node;
            this.dist = dist;
            this.reach = reach;
            this.parent = parent;
            this.depth = parent != null ? parent.depth + 1 : 0;
        }

        @Override
        public int compareTo(Record<N, E> o) {
            return Float.compare(this.dist, o.dist);
        }
    }
}

