/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.builders;

import net.automatalib.automata.fsa.MutableDFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.automata.fsa.impl.compact.CompactNFA;
import net.automatalib.automata.transducers.MutableMealyMachine;
import net.automatalib.automata.transducers.MutableMooreMachine;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.automata.transducers.impl.compact.CompactMealyTransition;
import net.automatalib.automata.transducers.impl.compact.CompactMoore;
import net.automatalib.util.automata.builders.DFABuilder;
import net.automatalib.util.automata.builders.FSABuilder;
import net.automatalib.util.automata.builders.MealyBuilder;
import net.automatalib.util.automata.builders.MooreBuilder;
import net.automatalib.words.Alphabet;

public final class AutomatonBuilders {
    private AutomatonBuilders() {
    }

    public static <I> DFABuilder<Integer, I, CompactDFA<I>> newDFA(Alphabet<I> alphabet) {
        return AutomatonBuilders.forDFA(new CompactDFA<I>(alphabet));
    }

    public static <S, I, A extends MutableDFA<S, ? super I>> DFABuilder<S, I, A> forDFA(A dfa) {
        return new DFABuilder(dfa);
    }

    public static <I> FSABuilder<Integer, I, CompactNFA<I>> newNFA(Alphabet<I> alphabet) {
        return new FSABuilder(new CompactNFA<I>(alphabet));
    }

    public static <I, O> MealyBuilder<Integer, I, CompactMealyTransition<O>, O, CompactMealy<I, O>> newMealy(Alphabet<I> alphabet) {
        return AutomatonBuilders.forMealy(new CompactMealy(alphabet));
    }

    public static <S, I, T, O, A extends MutableMealyMachine<S, ? super I, T, ? super O>> MealyBuilder<S, I, T, O, A> forMealy(A mealy) {
        return new MealyBuilder(mealy);
    }

    public static <I, O> MooreBuilder<Integer, I, Integer, O, CompactMoore<I, O>> newMoore(Alphabet<I> alphabet) {
        return AutomatonBuilders.forMoore(new CompactMoore(alphabet));
    }

    public static <S, I, T, O, A extends MutableMooreMachine<S, ? super I, T, ? super O>> MooreBuilder<S, I, T, O, A> forMoore(A moore) {
        return new MooreBuilder(moore);
    }
}

