/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.taf.parser;

import java.io.PrintStream;
import java.text.MessageFormat;
import net.automatalib.serialization.taf.parser.TAFParseDiagnosticListener;

public class PrintStreamDiagnosticListener
implements TAFParseDiagnosticListener {
    private static final PrintStreamDiagnosticListener STDERR_INSTANCE = new PrintStreamDiagnosticListener(System.err);
    private final PrintStream ps;

    public PrintStreamDiagnosticListener(PrintStream ps) {
        this.ps = ps;
    }

    public static TAFParseDiagnosticListener getStderrDiagnosticListener() {
        return STDERR_INSTANCE;
    }

    @Override
    public void error(int line, int col, String msgFmt, Object ... args) {
        this.ps.printf("Error: at line %d, column %d: %s%n", line, col, MessageFormat.format(msgFmt, args));
        this.ps.flush();
    }

    @Override
    public void warning(int line, int col, String msgFmt, Object ... args) {
        this.ps.printf("Warning: at line %d, column %d: %s%n", line, col, MessageFormat.format(msgFmt, args));
        this.ps.flush();
    }
}

