/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelcheckers.ltsmin.monitor;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.automata.transducers.impl.compact.CompactMealyTransition;
import net.automatalib.exception.ModelCheckingException;
import net.automatalib.modelcheckers.ltsmin.LTSminLTLParser;
import net.automatalib.modelcheckers.ltsmin.LTSminMealy;
import net.automatalib.modelcheckers.ltsmin.monitor.AbstractLTSminMonitor;
import net.automatalib.serialization.fsm.parser.FSMFormatException;
import net.automatalib.words.Word;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLTSminMonitorMealy<I, O>
extends AbstractLTSminMonitor<I, MealyMachine<?, I, ?, O>, MealyMachine<?, I, ?, O>>
implements LTSminMealy<I, O, MealyMachine<?, I, ?, O>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLTSminMonitorMealy.class);
    private final Function<String, O> string2Output;
    private Collection<? super O> skipOutputs;

    protected AbstractLTSminMonitorMealy(boolean keepFiles, Function<String, I> string2Input, Function<String, O> string2Output, Collection<? super O> skipOutputs) {
        super(keepFiles, string2Input);
        this.string2Output = string2Output;
        this.skipOutputs = skipOutputs;
    }

    @Override
    public Function<String, O> getString2Output() {
        return this.string2Output;
    }

    @Override
    public Collection<? super O> getSkipOutputs() {
        return this.skipOutputs;
    }

    @Override
    public void setSkipOutputs(Collection<? super O> skipOutputs) {
        this.skipOutputs = skipOutputs;
    }

    @Override
    protected void verifyFormula(String formula) {
        LTSminLTLParser.requireValidIOFormula(formula);
    }

    @Override
    public @Nullable MealyMachine<?, I, ?, O> findCounterExample(MealyMachine<?, I, ?, O> automaton, Collection<? extends I> inputs, String property) {
        File fsm = this.findCounterExampleFSM(automaton, inputs, property);
        if (fsm == null) {
            return null;
        }
        try {
            final CompactMealy result = this.fsm2Mealy(fsm, automaton, inputs);
            final Integer deadlock = result.getStates().stream().filter(s2 -> inputs.stream().allMatch(i -> result.getSuccessor(s2, i) == null)).findFirst().orElseThrow(() -> new ModelCheckingException("No deadlock found"));
            MealyMachine mealyMachine = new MealyMachine<Integer, I, CompactMealyTransition<O>, O>(){

                @Override
                public Word<O> computeStateOutput(Integer state, Iterable<? extends I> input) {
                    Integer succ = this.getSuccessor(state, input);
                    return deadlock.equals(succ) ? MealyMachine.super.computeStateOutput(state, input) : Word.epsilon();
                }

                @Override
                public @Nullable Integer getInitialState() {
                    return result.getInitialState();
                }

                @Override
                public Integer getSuccessor(CompactMealyTransition<O> transition) {
                    return result.getSuccessor(transition);
                }

                @Override
                public @Nullable CompactMealyTransition<O> getTransition(Integer state, I input) {
                    return (CompactMealyTransition)result.getTransition(state, input);
                }

                @Override
                public O getTransitionOutput(CompactMealyTransition<O> transition) {
                    return result.getTransitionOutput(transition);
                }

                @Override
                public Collection<Integer> getStates() {
                    return result.getStates();
                }
            };
            return mealyMachine;
        }
        catch (IOException | FSMFormatException e) {
            throw new ModelCheckingException(e);
        }
        finally {
            if (!this.isKeepFiles() && !fsm.delete()) {
                LOGGER.warn("Could not delete file: " + fsm.getAbsolutePath());
            }
        }
    }
}

