/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.visualization.DefaultVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public abstract class AbstractIncrementalMealyBuilder<I, O>
implements IncrementalMealyBuilder<I, O>,
Serializable {
    @Override
    public boolean hasDefinitiveInformation(Word<? extends I> word) {
        ArrayList unused = new ArrayList(word.length());
        return this.lookup(word, unused);
    }

    @Override
    public Word<O> lookup(Word<? extends I> inputWord) {
        WordBuilder wb = new WordBuilder(inputWord.size());
        this.lookup(inputWord, wb);
        return wb.toWord();
    }

    public static abstract class AbstractGraphView<I, O, N, E>
    implements IncrementalMealyBuilder.GraphView<I, O, N, E> {
        @Override
        public VisualizationHelper<N, E> getVisualizationHelper() {
            return new DefaultVisualizationHelper<N, E>(){

                @Override
                public Collection<N> initialNodes() {
                    return Collections.singleton(this.getInitialNode());
                }

                @Override
                public boolean getEdgeProperties(N src, E edge, N tgt, Map<String, String> properties) {
                    if (!super.getEdgeProperties(src, edge, tgt, properties)) {
                        return false;
                    }
                    Object input = this.getInputSymbol(edge);
                    Object output = this.getOutputSymbol(edge);
                    properties.put("label", input + " / " + output);
                    return true;
                }
            };
        }
    }
}

