/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.extension.gui.dock.util.MouseOverListener;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.util.Path;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public abstract class AbstractBubbleDockTitle
extends AbstractDockTitle {
    protected static final String ANIMATION_KEY_TEXT = "text";
    protected static final String ANIMATION_KEY_BACKGROUND_TOP = "top";
    protected static final String ANIMATION_KEY_BACKGROUND_BOTTOM = "bottom";
    private BubbleColorAnimation animation;
    private MouseOverListener mouseover;
    private int arc = 16;
    private List<BubbleTitleColor> colors = new ArrayList<BubbleTitleColor>();

    public AbstractBubbleDockTitle(Dockable dockable, DockTitleVersion origin) {
        this(dockable, origin, true);
    }

    public AbstractBubbleDockTitle(Dockable dockable, DockTitleVersion origin, boolean showMiniButtons) {
        this.init(dockable, origin, showMiniButtons);
    }

    protected AbstractBubbleDockTitle() {
    }

    protected void init(Dockable dockable, DockTitleVersion origin, boolean showMiniButtons) {
        super.init(dockable, origin, showMiniButtons);
        this.setOpaque(false);
        this.initAnimation();
        this.mouseover = new MouseOverListener(this.getComponent()){

            protected void changed() {
                AbstractBubbleDockTitle.this.updateAnimation();
            }
        };
    }

    public boolean isMouseOver() {
        return !this.isDisabled() && this.mouseover == null ? false : this.mouseover.isMouseOver();
    }

    protected void addColor(String id, Path kind, Color backup) {
        BubbleTitleColor color = new BubbleTitleColor(id, kind, backup);
        this.colors.add(color);
        this.addColor(color);
    }

    private void initAnimation() {
        this.setTransparency(Transparency.DEFAULT);
        this.animation = new BubbleColorAnimation();
        this.updateAnimation();
        this.animation.addTask(new Runnable(){

            public void run() {
                AbstractBubbleDockTitle.this.pulse();
            }
        });
        this.setForeground(this.animation.getColor(ANIMATION_KEY_TEXT));
    }

    public void bind() {
        super.bind();
        this.animation.kick();
    }

    public void setActive(boolean active) {
        if (this.isActive() != active) {
            super.setActive(active);
            this.updateAnimation();
        }
    }

    protected void setDisabled(boolean disabled) {
        if (this.isDisabled() != disabled) {
            super.setDisabled(disabled);
            this.updateAnimation();
        }
    }

    protected abstract void updateAnimation();

    protected void updateAnimation(String animationKey, String colorId) {
        for (BubbleTitleColor color : this.colors) {
            if (!colorId.equals(color.getId())) continue;
            this.animation.putColor(animationKey, color.color());
            break;
        }
    }

    protected Color getColor(String animationKey) {
        return this.animation.getColor(animationKey);
    }

    protected void pulse() {
        this.setForeground(this.animation.getColor(ANIMATION_KEY_TEXT));
        this.repaint();
    }

    protected Insets getInnerInsets() {
        int edge = this.arc / 4;
        switch (this.getOrientation()) {
            case EAST_SIDED: {
                return new Insets(edge, edge / 2, edge, edge);
            }
            case FREE_HORIZONTAL: {
                return new Insets(edge, edge, edge, edge);
            }
            case FREE_VERTICAL: {
                return new Insets(edge, edge, edge, edge);
            }
            case NORTH_SIDED: {
                return new Insets(edge, edge, edge / 2, edge);
            }
            case SOUTH_SIDED: {
                return new Insets(edge / 2, edge, edge, edge);
            }
            case WEST_SIDED: {
                return new Insets(edge, edge, edge, edge / 2);
            }
        }
        return super.getInnerInsets();
    }

    protected void paintBackground(Graphics g, JComponent component) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.doPaintBackground(g2, component);
        g2.dispose();
    }

    protected void doPaintBackground(Graphics g, JComponent component) {
        Graphics2D g2 = (Graphics2D)g;
        Insets insets = this.getInsets();
        int x = 0;
        int y = 0;
        int w = component.getWidth();
        int h = component.getHeight();
        if (insets != null) {
            x = insets.left;
            y = insets.top;
            w -= insets.left + insets.right;
            h -= insets.top + insets.bottom;
        }
        Color top = this.animation.getColor(ANIMATION_KEY_BACKGROUND_TOP);
        Color bottom = this.animation.getColor(ANIMATION_KEY_BACKGROUND_BOTTOM);
        if (top != null && bottom != null) {
            if (this.getOrientation().isHorizontal()) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, top, 0.0f, h, bottom));
            } else {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, top, w, 0.0f, bottom));
            }
            this.drawRoundRect(g2, x, y, w, h);
        }
    }

    public void paintOverlay(Graphics g) {
        Rectangle clip;
        Graphics2D g2 = (Graphics2D)g.create();
        Insets insets = this.getInsets();
        int x = 0;
        int y = 0;
        int w = this.getWidth();
        int h = this.getHeight();
        if (insets != null) {
            x = insets.left;
            y = insets.top;
            w -= insets.left + insets.right;
            h -= insets.top + insets.bottom;
        }
        if ((clip = g.getClipBounds()) == null) {
            clip = new Rectangle(x, y, w, h);
        }
        if (this.getOrientation().isHorizontal()) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(150, 150, 150), 0.0f, h / 2, Color.WHITE));
            g2.setComposite(AlphaComposite.getInstance(10, 0.4f));
            g2.setClip(0, 0, w, h / 2);
            g2.clipRect(clip.x, clip.y, clip.width, clip.height);
        } else {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(150, 150, 150), w / 2, 0.0f, Color.WHITE));
            g2.setComposite(AlphaComposite.getInstance(10, 0.4f));
            g2.setClip(0, 0, w / 2, h);
            g2.clipRect(clip.x, clip.y, clip.width, clip.height);
        }
        this.drawRoundRect(g2, x, y, w, h);
        g2.dispose();
    }

    private void drawRoundRect(Graphics2D g2, int x, int y, int w, int h) {
        switch (this.getOrientation()) {
            case FREE_HORIZONTAL: 
            case FREE_VERTICAL: {
                g2.fillRoundRect(x, y, w, h, this.arc, this.arc);
                break;
            }
            case EAST_SIDED: {
                g2.fillRoundRect(x - this.arc, y, w + this.arc, h, this.arc, this.arc);
                break;
            }
            case NORTH_SIDED: {
                g2.fillRoundRect(x, y, w, h + this.arc, this.arc, this.arc);
                break;
            }
            case SOUTH_SIDED: {
                g2.fillRoundRect(x, y - this.arc, w, h + this.arc, this.arc, this.arc);
                break;
            }
            case WEST_SIDED: {
                g2.fillRoundRect(x, y, w + this.arc, h, this.arc, this.arc);
            }
        }
    }

    private class BubbleTitleColor
    extends TitleColor {
        public BubbleTitleColor(String id, Path kind, Color backup) {
            super(id, kind, AbstractBubbleDockTitle.this, backup);
        }

        protected void changed(Color oldColor, Color newColor) {
            AbstractBubbleDockTitle.this.updateAnimation();
        }
    }
}

