/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.TextToken;
import de.renew.util.Types;
import java.io.Serializable;

public final class Value
implements TextToken,
Serializable {
    public final Object value;
    public static final Object IMPOSSIBLE_CAST = new Object();

    public Value(Object value) {
        if (!(value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof Boolean)) {
            if (value instanceof Value) {
                throw new RuntimeException("Tried to make a nested value. Strange.");
            }
            if (value instanceof Throwable) {
                throw new RuntimeException("Tried to make a Throwable a value. Strange. Throwable is: " + String.valueOf(value), (Throwable)value);
            }
            throw new RuntimeException("Tried to make object " + String.valueOf(value) + " a value. Strange.");
        }
        this.value = value;
    }

    public int hashCode() {
        return this.value.hashCode() + 517293561;
    }

    public boolean equals(Object that) {
        if (that instanceof Value) {
            return this.value.equals(((Value)that).value);
        }
        return false;
    }

    public boolean booleanValue() {
        return (Boolean)this.value;
    }

    public char charValue() {
        return ((Character)this.value).charValue();
    }

    public byte byteValue() {
        return ((Number)this.value).byteValue();
    }

    public short shortValue() {
        return ((Number)this.value).shortValue();
    }

    public int intValue() {
        return ((Number)this.value).intValue();
    }

    public long longValue() {
        return ((Number)this.value).longValue();
    }

    public float floatValue() {
        return ((Number)this.value).floatValue();
    }

    public double doubleValue() {
        return ((Number)this.value).doubleValue();
    }

    @Override
    public String toTokenText() {
        return this.value.toString();
    }

    public String toString() {
        return String.valueOf(Types.typify(this.value.getClass())) + "(" + String.valueOf(this.value) + ")";
    }

    public static Object possiblyWrap(Object obj, boolean wrap) {
        if (wrap) {
            obj = new Value(obj);
        }
        return obj;
    }

    public static Object convertPrimitive(Object value, Class<?> clazz) {
        if (value instanceof Character) {
            if (clazz == Character.TYPE) {
                return value;
            }
            value = (int)((Character)value).charValue();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (clazz == Double.TYPE) {
                return number.doubleValue();
            }
            if (number instanceof Double) {
                throw new IllegalArgumentException();
            }
            if (clazz == Float.TYPE) {
                return Float.valueOf(number.floatValue());
            }
            if (number instanceof Float) {
                throw new IllegalArgumentException();
            }
            if (clazz == Long.TYPE) {
                return number.longValue();
            }
            if (number instanceof Long) {
                throw new IllegalArgumentException();
            }
            if (clazz == Integer.TYPE) {
                return number.intValue();
            }
            if (number instanceof Integer) {
                throw new IllegalArgumentException();
            }
            if (clazz == Short.TYPE) {
                return number.shortValue();
            }
            if (number instanceof Short) {
                throw new IllegalArgumentException();
            }
            if (clazz == Byte.TYPE) {
                return number.byteValue();
            }
            throw new IllegalArgumentException();
        }
        if (value instanceof Boolean) {
            if (clazz == Boolean.TYPE) {
                return value;
            }
            throw new IllegalArgumentException();
        }
        throw new RuntimeException("Encountered a bad value.");
    }

    public Object unvalueAndCast(Class<?> clazz) throws IllegalArgumentException {
        if (clazz.isPrimitive()) {
            return Value.convertPrimitive(this.value, clazz);
        }
        throw new IllegalArgumentException();
    }

    public static Object unvalueAndCast(Object obj, Class<?> clazz) throws IllegalArgumentException {
        if (obj instanceof Value) {
            return ((Value)obj).unvalueAndCast(clazz);
        }
        if (obj == null || clazz.isInstance(obj)) {
            return obj;
        }
        throw new IllegalArgumentException();
    }

    public static Object[] unvalueAndCast(Object[] objs, Class<?>[] clazzes) throws IllegalArgumentException {
        Object[] results = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            results[i] = Value.unvalueAndCast(objs[i], clazzes[i]);
        }
        return results;
    }

    public static Object castOrReturnImpossible(Class<?> clazz, Object arg) {
        if (clazz.isPrimitive()) {
            if (arg instanceof Value) {
                Object value = ((Value)arg).value;
                if (value instanceof Boolean) {
                    if (clazz == Boolean.TYPE) {
                        return arg;
                    }
                } else {
                    Number number;
                    if (value instanceof Character) {
                        char charVal = ((Character)value).charValue();
                        number = (int)charVal;
                    } else {
                        number = (Number)value;
                    }
                    if (clazz == Character.TYPE) {
                        return new Value(Character.valueOf((char)number.intValue()));
                    }
                    if (clazz == Byte.TYPE) {
                        return new Value(number.byteValue());
                    }
                    if (clazz == Short.TYPE) {
                        return new Value(number.shortValue());
                    }
                    if (clazz == Integer.TYPE) {
                        return new Value(number.intValue());
                    }
                    if (clazz == Long.TYPE) {
                        return new Value(number.longValue());
                    }
                    if (clazz == Float.TYPE) {
                        return new Value(Float.valueOf(number.floatValue()));
                    }
                    if (clazz == Double.TYPE) {
                        return new Value(number.doubleValue());
                    }
                }
            }
        } else if (arg == null || clazz.isInstance(arg)) {
            return arg;
        }
        return IMPOSSIBLE_CAST;
    }
}

