/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class Types {
    public static final Logger logger = Logger.getLogger(Types.class);
    public static final Class<?> UNTYPED = new Object(){}.getClass();
    public static final String[] NOPACKAGES = null;
    public static final String[] ALLPACKAGES = new String[0];
    private static int _assertionCount = 0;

    private Types() {
    }

    public static Class<?> objectify(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        return clazz;
    }

    public static boolean isFinal(Class<?> clazz) {
        if (clazz == null || clazz == UNTYPED) {
            return true;
        }
        return (clazz.getModifiers() & 0x10) != 0;
    }

    public static boolean allowsIdentityConversion(Class<?> from, Class<?> to) {
        return to == from;
    }

    public static boolean allowsPrimitiveWidening(Class<?> from, Class<?> to) {
        if (to == null || to == UNTYPED) {
            return false;
        }
        if (to == from) {
            return false;
        }
        if (from == null || from == UNTYPED) {
            return false;
        }
        if (!to.isPrimitive() || !from.isPrimitive()) {
            return false;
        }
        if (to == Void.TYPE || from == Void.TYPE) {
            return false;
        }
        if (to == Boolean.TYPE || from == Boolean.TYPE) {
            return false;
        }
        if (to == Character.TYPE) {
            return false;
        }
        if (to == Double.TYPE) {
            return true;
        }
        if (from == Double.TYPE) {
            return false;
        }
        if (to == Float.TYPE) {
            return true;
        }
        if (from == Float.TYPE) {
            return false;
        }
        if (to == Long.TYPE) {
            return true;
        }
        if (from == Long.TYPE) {
            return false;
        }
        if (to == Integer.TYPE) {
            return true;
        }
        return from == Byte.TYPE;
    }

    public static boolean allowsReferenceWidening(Class<?> from, Class<?> to) {
        if (to == null || to == UNTYPED) {
            return false;
        }
        if (to == from) {
            return false;
        }
        if (from == UNTYPED) {
            return false;
        }
        if (from == null) {
            return !to.isPrimitive();
        }
        if (to.isPrimitive() || from.isPrimitive()) {
            return false;
        }
        return to.isAssignableFrom(from);
    }

    public static boolean allowsLosslessWidening(Class<?> from, Class<?> to) {
        if (!Types.allowsWideningConversion(from, to)) {
            return false;
        }
        return !(from == Integer.TYPE && to == Float.TYPE || from == Long.TYPE && to == Float.TYPE || from == Long.TYPE && to == Double.TYPE);
    }

    public static boolean allowsWideningConversion(Class<?> from, Class<?> to) {
        return Types.allowsIdentityConversion(from, to) || Types.allowsPrimitiveWidening(from, to) || Types.allowsReferenceWidening(from, to);
    }

    public static boolean allowsWideningConversion(Class<?>[] from, Class<?>[] to) {
        if (from.length != to.length) {
            return false;
        }
        for (int i = 0; i < from.length; ++i) {
            if (Types.allowsWideningConversion(from[i], to[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean allowsCast(Class<?> from, Class<?> to) {
        Method[] methods;
        if (to == null || to == UNTYPED) {
            return false;
        }
        if (from == null) {
            return !to.isPrimitive();
        }
        if (from == UNTYPED) {
            return true;
        }
        while (from.isArray() && to.isArray()) {
            from = from.getComponentType();
            to = to.getComponentType();
        }
        if (Types.allowsIdentityConversion(from, to)) {
            return true;
        }
        if (to.isPrimitive() || from.isPrimitive()) {
            if (!to.isPrimitive() || !from.isPrimitive()) {
                return false;
            }
            return to != Boolean.TYPE && from != Boolean.TYPE && to != Void.TYPE && from != Void.TYPE;
        }
        if (Types.allowsReferenceWidening(from, to)) {
            return true;
        }
        if (Types.allowsReferenceWidening(to, from)) {
            return true;
        }
        if (Types.isFinal(from)) {
            return false;
        }
        if (Types.isFinal(to)) {
            return false;
        }
        if (!to.isInterface() && !from.isInterface()) {
            return false;
        }
        for (Method method : methods = from.getMethods()) {
            try {
                Method otherMethod = to.getMethod(method.getName(), method.getParameterTypes());
                if (otherMethod.getReturnType() == method.getReturnType()) continue;
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static Class<?> typify(Class<?> clazz) {
        if (clazz == Void.class) {
            return Void.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        throw new RuntimeException("Cannot make primitive type from " + String.valueOf(clazz));
    }

    public static String typeToString(Class<?> clazz) {
        return Types.typeToString(clazz, ALLPACKAGES);
    }

    public static String typeToString(Class<?> clazz, String[] packages) {
        if (clazz == UNTYPED) {
            return "untyped";
        }
        if (clazz == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        while (clazz.isArray()) {
            buf.append("[]");
            clazz = clazz.getComponentType();
        }
        String baseName = clazz.getName();
        String pureName = Types.getPureName(baseName);
        String peckage = null;
        if (packages != null) {
            peckage = Types.getPackageName(baseName);
            for (int i = 0; peckage != null && i < packages.length; ++i) {
                if (!peckage.equals(packages[i])) continue;
                peckage = null;
                break;
            }
        }
        StringBuilder result = new StringBuilder();
        if (peckage != null) {
            result.append(peckage).append('.');
        }
        return result.append(pureName).append((CharSequence)buf).toString();
    }

    public static String getPackageName(Class<?> clazz) {
        return Types.getPackageName(Types.typeToString(clazz, ALLPACKAGES));
    }

    public static String getPureName(Class<?> clazz) {
        return Types.getPureName(Types.typeToString(clazz, ALLPACKAGES));
    }

    public static String getPackageName(String className) {
        int lastDotPos = className.lastIndexOf(".");
        if (lastDotPos < 0) {
            return null;
        }
        return className.substring(0, lastDotPos);
    }

    public static String getPureName(String className) {
        int lastDotPos = className.lastIndexOf(".");
        if (lastDotPos < 0) {
            return className;
        }
        return className.substring(lastDotPos + 1);
    }

    private static void assertTrue(boolean correct) {
        ++_assertionCount;
        if (!correct) {
            logger.error((Object)("Assertion " + _assertionCount + " failed."));
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        Types.assertTrue(!Types.allowsCast(Integer.class, Integer.TYPE));
        Types.assertTrue(Types.allowsCast(null, Integer.class));
        Types.assertTrue(!Types.allowsCast(null, Integer.TYPE));
        Types.assertTrue(Types.allowsCast(Object.class, Integer.class));
        Types.assertTrue(Types.allowsCast(Object.class, Object[].class));
        Types.assertTrue(Types.allowsCast(Cloneable.class, Object[].class));
        Types.assertTrue(!Types.allowsCast(String.class, Number.class));
        Types.assertTrue(!Types.allowsCast(String.class, Number.class));
        Types.assertTrue("int[]".equals(Types.typeToString(int[].class, ALLPACKAGES)));
        Types.assertTrue("int[]".equals(Types.typeToString(int[].class, NOPACKAGES)));
        Types.assertTrue("java.lang.Object[]".equals(Types.typeToString(Object[].class, ALLPACKAGES)));
        Types.assertTrue("Object[]".equals(Types.typeToString(Object[].class, NOPACKAGES)));
        Types.assertTrue("java.lang.Integer".equals(Types.typeToString(Integer.class, new String[]{"java.lung"})));
        Types.assertTrue("java.lang.Integer".equals(Types.typeToString(Integer.class)));
        Types.assertTrue("Integer".equals(Types.typeToString(Integer.class, new String[]{"java.lang"})));
    }
}

