/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.creator;

import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.pnml.creator.NetCreator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class PNMLCreator {
    private static final Logger logger = Logger.getLogger(PNMLCreator.class);
    private static final String xmlNamespace = "http://www.pnml.org/version-2009/grammar/pnml";
    private final String _netType;
    private final boolean _toolInsc;
    private Document _doc;

    public PNMLCreator(String netType, boolean toolInsc) {
        this._netType = netType;
        this._toolInsc = toolInsc;
    }

    private static Transformer createTransformer() {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public List<PlaceFigure> setDrawings(CPNDrawing drawing) throws ParserConfigurationException {
        this.makeDoc();
        return this.addNet(drawing);
    }

    private void setDrawings(CPNDrawing[] drawings) throws ParserConfigurationException {
        this.makeDoc();
        for (CPNDrawing drawing : drawings) {
            this.addNet(drawing);
        }
    }

    public void write(OutputStream stream, CPNDrawing drawing) throws Exception {
        this.setDrawings(drawing);
        this.writeXML(stream);
    }

    public void write(OutputStream stream, CPNDrawing[] drawings) throws Exception {
        this.setDrawings(drawings);
        this.writeXML(stream);
    }

    private void makeDoc() throws ParserConfigurationException {
        DOMImplementation di = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
        DocumentType dt = di.createDocumentType("PNMLFile", null, null);
        this._doc = di.createDocument(xmlNamespace, "pnml", dt);
    }

    private List<PlaceFigure> addNet(CPNDrawing drawing) {
        Element eRoot = this._doc.getDocumentElement();
        NetCreator netCreator = new NetCreator(this._netType, this._toolInsc);
        eRoot.appendChild(netCreator.createElement(this, drawing));
        return netCreator.getPlaceList();
    }

    private void writeXML(OutputStream stream) {
        Transformer transformer = PNMLCreator.createTransformer();
        DOMSource source = new DOMSource(this._doc);
        StreamResult result = new StreamResult(stream);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            logger.error((Object)(PNMLCreator.class.getSimpleName() + ": " + e.getLocalizedMessage()), (Throwable)e);
        }
        try {
            stream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Element createElement(String tagName) {
        return this._doc.createElement(tagName);
    }

    public Element createToolspecific() {
        Element toolSpec = this.createElement("toolspecific");
        toolSpec.setAttribute("tool", "renew");
        toolSpec.setAttribute("version", "2.0");
        return toolSpec;
    }

    public Element createTextElement(String text) {
        Element element = this.createElement("text");
        element.appendChild(this._doc.createTextNode(text));
        return element;
    }

    public Element getDocumentElement() {
        return this._doc.getDocumentElement();
    }
}

