/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.configure;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

class ConfigureEngineTab
extends JPanel {
    private JCheckBox sequentialBox;
    private JTextField multiplicityField;
    private JCheckBox classReinitBox;
    private JCheckBox eagerSimulationBox;
    private JTextField priorityField;

    ConfigureEngineTab() {
        super(new GridBagLayout());
        this.initComponents();
    }

    private void initComponents() {
        this.setName("Engine");
        this.sequentialBox = new JCheckBox();
        JLabel multiplicityLabel = new JLabel();
        this.multiplicityField = new JTextField();
        this.priorityField = new JTextField();
        JLabel priorityLabel = new JLabel();
        this.classReinitBox = new JCheckBox();
        this.eagerSimulationBox = new JCheckBox();
        this.sequentialBox.setText("Sequential mode");
        this.sequentialBox.setToolTipText("If activated, transitions will be restricted to sequential firing.\nThis is needed for some arc types and formalisms.");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sequentialBox, gridBagConstraints);
        multiplicityLabel.setText("Multiplicity: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)multiplicityLabel, gridBagConstraints);
        this.multiplicityField.setToolTipText("Enter the number of concurrent binding search threads.\n(Values different from 1 are experimental!)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.7;
        this.add((Component)this.multiplicityField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)new JSeparator(), gridBagConstraints);
        this.classReinitBox.setText("Class reinit mode");
        this.classReinitBox.setToolTipText("If activated, custom classes (loaded from de.renew.classPath) will be reloaded on each simulation run.\n(This is an experimental feature!).");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.classReinitBox, gridBagConstraints);
        this.eagerSimulationBox.setText("Eager simulation mode");
        this.eagerSimulationBox.setToolTipText("If activated, the simulator will not wait for the graphical animation.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.eagerSimulationBox, gridBagConstraints);
        priorityLabel.setText("Simulation Priority (1-10): ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.add((Component)priorityLabel, gridBagConstraints);
        this.priorityField.setToolTipText("Enter the simulations thread priority.\n(Values range from 1 to 10. 10 being the highest)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.7;
        this.add((Component)this.priorityField, gridBagConstraints);
    }

    boolean getSequential() {
        return this.sequentialBox.getModel().isSelected();
    }

    void setSequential(boolean state) {
        this.sequentialBox.setSelected(state);
    }

    String getMultiplicity() {
        return this.multiplicityField.getText();
    }

    void setMultiplicity(String multiplicity) {
        this.multiplicityField.setText(multiplicity);
    }

    String getPriority() {
        return this.priorityField.getText();
    }

    void setPriority(String priority) {
        this.priorityField.setText(priority);
    }

    boolean getClassReinit() {
        return this.classReinitBox.getModel().isSelected();
    }

    void setClassReinit(boolean state) {
        this.classReinitBox.setSelected(state);
    }

    boolean getEagerSimulation() {
        return this.eagerSimulationBox.getModel().isSelected();
    }

    void setEagerSimulation(boolean state) {
        this.eagerSimulationBox.setSelected(state);
    }
}

