/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.UndoableCommand;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.gui.CPNDrawing;
import de.renew.gui.FigureWithHighlight;
import java.util.Vector;

public class HighlightAssociateCommand
extends UndoableCommand {
    public HighlightAssociateCommand(String name) {
        super(name);
    }

    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        Drawing drawing = EditorApi.getCurrentDrawing();
        DrawingView view = this.getEditor().view();
        if (drawing instanceof CPNDrawing && view.selectionCount() == 2) {
            FigureEnumeration sel = view.selectionElements();
            while (sel.hasMoreElements()) {
                if (!(sel.nextFigure() instanceof FigureWithHighlight)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean executeUndoable() {
        if (this.isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            CPNDrawing drawing = (CPNDrawing)EditorApi.getCurrentDrawing();
            DrawingView view = this.getEditor().view();
            Vector vfig = view.selection();
            int pos = -1;
            if (vfig.get(0) instanceof FigureWithHighlight) {
                pos = 0;
            } else if (vfig.get(1) instanceof FigureWithHighlight) {
                pos = 1;
            }
            FigureWithHighlight nf = (FigureWithHighlight)vfig.get(pos);
            Figure fig = (Figure)vfig.get(1 - pos);
            drawing.setHighlightFigure(nf, fig);
            this.getEditor().showStatus("Highlight associated!");
            return true;
        }
        this.getEditor().showStatus("Select a node (place or transition) and another figure!");
        return false;
    }
}

