/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.api.SimulationStateLoader;
import de.renew.application.IllegalCompilerException;
import de.renew.application.SimulatorExtensionAdapter;
import de.renew.application.SimulatorPlugin;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.gui.BindingSelectionFrame;
import de.renew.gui.BreakpointManager;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingLoader;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.GuiPlugin;
import de.renew.gui.ModeReplacement;
import de.renew.net.NetInstance;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.RemotePlugin;
import de.renew.shadowcompiler.ShadowCompilerFactory;
import de.renew.shadowcompiler.ShadowNetSystemCompiler;
import de.renew.shadowcompiler.ShadowNetSystemCreator;
import de.renew.simulator.api.SimulationManager;
import de.renew.simulator.api.SimulatorExtensions;
import de.renew.simulatorontology.loading.NetNotFoundException;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.renew.simulatorontology.simulation.NoSimulationException;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import de.renew.simulatorontology.simulation.SimulationRunningException;
import de.renew.simulatorontology.simulation.Simulator;
import de.renew.simulatorontology.simulation.SimulatorExtension;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class CPNSimulation {
    private static final Logger logger = Logger.getLogger(CPNSimulation.class);
    protected ShadowNetSystem netSystem;
    private final boolean sequentialOnly;
    private BreakpointManager breakpointManager = null;
    private final CPNDrawingLoader drawingLoader;
    private final SimulatorPlugin simulatorPlugin = SimulatorPlugin.getCurrent();
    public Exception lastSyntaxException;
    public boolean inGuiSetup;
    private SimulatorGuiCompilationExtension compilationExtension;

    public CPNSimulation(boolean onlySequential, CPNDrawingLoader loader) {
        this.sequentialOnly = onlySequential;
        this.drawingLoader = loader;
        this.inGuiSetup = false;
        this.lastSyntaxException = null;
        this.newNetSystem();
        this.compilationExtension = new SimulatorGuiCompilationExtension(this);
        SimulatorExtensions.addExtension((SimulatorExtension)this.compilationExtension);
    }

    public boolean isStrictlySequential() {
        return this.sequentialOnly;
    }

    public void buildAllShadows() {
        this.newNetSystem();
        boolean again = true;
        while (again) {
            again = false;
            Iterator<CPNDrawing> drawings = this.drawingLoader.loadedDrawings();
            try {
                while (drawings.hasNext()) {
                    CPNDrawing currentDrawing = drawings.next();
                    logger.debug((Object)("CPNSimulation: Building shadow for drawing " + String.valueOf(currentDrawing) + "."));
                    currentDrawing.buildShadow(this.netSystem);
                }
            }
            catch (ConcurrentModificationException e) {
                logger.error((Object)"CPNSimulation.buildAllShadows(): Concurrent modification. Redo from start...");
                again = true;
            }
        }
    }

    protected void newNetSystem() {
        try {
            this.simulatorPlugin.possiblySetupClassSource((Properties)this.simulatorPlugin.getProperties());
        }
        catch (IllegalStateException e) {
            logger.warn((Object)"CPNSimulation: Cannot configure classReinit mode while a simulation is running.");
        }
        ShadowCompilerFactory compilerFactory = ModeReplacement.getInstance().getDefaultCompilerFactory();
        if (compilerFactory == null) {
            logger.warn((Object)"CPNSimulation: cannot start, got no compiler.");
        }
        this.netSystem = ShadowNetSystemCreator.createWithCompiler((ShadowCompilerFactory)compilerFactory);
        logger.debug((Object)"CPNSimulation: New net system created.");
    }

    public ShadowNetSystem getNetSystem() {
        this.buildAllShadows();
        return this.netSystem;
    }

    public CPNDrawingLoader getDrawingLoader() {
        return this.drawingLoader;
    }

    public void setBreakpointManager(BreakpointManager newBreakpointManager) {
        BreakpointManager oldBreakpointManager = this.breakpointManager;
        this.breakpointManager = newBreakpointManager;
        if (oldBreakpointManager != null) {
            SimulatorExtensions.removeExtension((SimulatorExtension)oldBreakpointManager);
        }
        SimulatorExtensions.addExtension((SimulatorExtension)newBreakpointManager);
    }

    public BreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    public SimulatorPlugin getSimulatorPlugin() {
        return this.simulatorPlugin;
    }

    public void syntaxCheckOnly() throws SyntaxException {
        this.buildAllShadows();
        ShadowNetSystemCompiler.getInstance().compile(this.netSystem);
    }

    public NetInstanceAccessor initSimulation(String mainNet) throws SyntaxException, NetNotFoundException, NoSimulationException {
        this.inGuiSetup = true;
        this.lastSyntaxException = null;
        logger.trace((Object)"CPNSimulation: initializing simulation...");
        this.buildAllShadows();
        try {
            SimulationManager.setDefaultNetLoader();
            try {
                logger.trace((Object)"CPNSimulation: calling setupSimulation...");
                SimulationManager.setupSimulation(null);
                logger.trace((Object)"CPNSimulation: finished setupSimulation...");
            }
            catch (SimulationRunningException e) {
                logger.warn((Object)"Simulation already running, inserting nets anyway");
            }
            if (this.lastSyntaxException != null) {
                logger.trace((Object)("CPNSimulation: forwarding (rethrowing) exception: " + String.valueOf(this.lastSyntaxException)));
                SimulationManager.terminateSimulation();
                Exception exception = this.lastSyntaxException;
                if (exception instanceof SyntaxException) {
                    SyntaxException syntaxException = (SyntaxException)((Object)exception);
                    throw syntaxException;
                }
                exception = this.lastSyntaxException;
                if (exception instanceof IllegalCompilerException) {
                    IllegalCompilerException ice = (IllegalCompilerException)((Object)exception);
                    throw ice;
                }
                throw new RuntimeException("Unexpected Exception type: " + String.valueOf(this.lastSyntaxException), this.lastSyntaxException);
            }
            logger.trace((Object)("CPNSimulation: instantiating net " + mainNet + "..."));
            NetInstanceAccessor primaryInstance = null;
            if (RemotePlugin.getInstance() != null) {
                primaryInstance = RemotePlugin.getInstance().wrapInstance(this.simulatorPlugin.createNetInstance(mainNet));
            }
            if (primaryInstance == null) {
                logger.trace((Object)("CPNSimulation: instantiation of net " + mainNet + " failed."));
                SimulationManager.terminateSimulation();
            }
            NetInstanceAccessor netInstanceAccessor = primaryInstance;
            return netInstanceAccessor;
        }
        catch (NoSimulationException e) {
            logger.info((Object)"CPNSimulation: Simulation terminated externally.");
            throw e;
        }
        catch (NetNotFoundException | Error | RuntimeException e) {
            logger.trace((Object)("CPNSimulation: catching and rethrowing exception: " + String.valueOf(e)));
            SimulationManager.terminateSimulation();
            throw e;
        }
        finally {
            this.inGuiSetup = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(ObjectOutput output) throws IOException {
        SimulatorPlugin simulatorPlugin = this.simulatorPlugin;
        synchronized (simulatorPlugin) {
            SimulationManager.getCurrentSimulator().stopRun();
            BindingSelectionFrame.close();
            NetInstance[] instances = CPNInstanceDrawing.getAllLocalInstances();
            this.simulatorPlugin.saveState(output, instances);
        }
    }

    public void loadState(ObjectInput input) throws IOException, ClassNotFoundException, SimulationRunningException {
        NetInstance[] instances = SimulationStateLoader.loadState((ObjectInput)input, null);
        CPNApplication editor = GuiPlugin.getCurrent().getGui();
        RemotePlugin remote = RemotePlugin.getInstance();
        for (NetInstance instance : instances) {
            NetInstanceAccessor currentInstance = remote.wrapInstance(instance);
            if (editor == null) continue;
            editor.openInstanceDrawing(currentInstance);
        }
    }

    public boolean isSimulationActive() {
        return SimulationManager.isSimulationActive();
    }

    public void simulationTerminate() {
        SimulationManager.terminateSimulation();
    }

    public void simulationRefresh() {
        SimulationThreadPool.getCurrent().submitAndWait(() -> {
            Simulator simulator = SimulationManager.getCurrentSimulator();
            if (simulator != null) {
                simulator.refresh();
            }
            return null;
        });
    }

    public void simulationStop() {
        SimulationThreadPool.getCurrent().submitAndWait(() -> {
            Simulator simulator = SimulationManager.getCurrentSimulator();
            if (simulator != null) {
                simulator.stopRun();
            }
            return null;
        });
    }

    public void simulationRun() {
        SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() {
                Simulator simulator = SimulationManager.getCurrentSimulator();
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (CPNSimulation.this.breakpointManager != null) {
                        CPNSimulation.this.breakpointManager.clearLog();
                    }
                    if (simulator != null) {
                        try {
                            simulator.startRun();
                        }
                        catch (RuntimeException e) {
                            logger.warn((Object)("Caught exception while trying to start simulation: " + String.valueOf(e)), (Throwable)e);
                            throw e;
                        }
                    }
                }
                return null;
            }
        });
    }

    public int simulationStep() {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() {
                Simulator simulator = SimulationManager.getCurrentSimulator();
                2 var2_2 = this;
                synchronized (var2_2) {
                    if (CPNSimulation.this.breakpointManager != null) {
                        CPNSimulation.this.breakpointManager.clearLog();
                    }
                    if (simulator != null) {
                        return simulator.step();
                    }
                    return 4;
                }
            }
        });
        try {
            return (Integer)future.get();
        }
        catch (InterruptedException e) {
            logger.info((Object)"Net step aborted");
        }
        catch (ExecutionException e) {
            logger.error((Object)("Exception during execution of simulation step: " + String.valueOf(e)));
        }
        return 4;
    }

    public void dispose() {
        SimulatorExtensions.removeExtension((SimulatorExtension)this.compilationExtension);
        this.compilationExtension = null;
    }

    private static class SimulatorGuiCompilationExtension
    extends SimulatorExtensionAdapter {
        private final CPNSimulation sim;

        public SimulatorGuiCompilationExtension(CPNSimulation sim) {
            this.sim = sim;
            logger.trace((Object)"SimGuiCompilationExt created.");
        }

        public void simulationSetup(SimulationEnvironment env) {
            ShadowNetSystem netSystem;
            super.simulationSetup(env);
            if (this.sim.inGuiSetup) {
                logger.trace((Object)"SimGuiCompilationExt: setup called within guiSetup.");
                netSystem = this.sim.netSystem;
            } else {
                logger.trace((Object)"SimGuiCompilationExt: setup called concurrently.");
                netSystem = this.sim.getNetSystem();
            }
            try {
                SimulationManager.addShadowNetSystem((ShadowNetSystem)netSystem);
                logger.trace((Object)"SimGuiCompilationExt: finished initial compilation.");
            }
            catch (NoSimulationException e) {
                logger.error((Object)"This is absurd: no simulation during simulation setup", (Throwable)e);
            }
            catch (SyntaxException e) {
                if (this.sim.inGuiSetup) {
                    this.sim.lastSyntaxException = e;
                } else {
                    logger.warn((Object)("SyntaxException in editor nets during non-gui simulation setup:\n" + e.getMessage()), (Throwable)e);
                }
            }
            catch (IllegalCompilerException e) {
                if (this.sim.inGuiSetup) {
                    this.sim.lastSyntaxException = e;
                }
                logger.warn((Object)("IllegalCompilerException in editor nets during non-gui simulation setup:\n" + e.getMessage()), (Throwable)e);
            }
        }
    }
}

