/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadowcompiler;

import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.shadowcompiler.ShadowLookup;
import de.renew.simulatorontology.shadow.ShadowPlace;
import de.renew.simulatorontology.shadow.ShadowTransition;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class ContextLookup {
    private final Hashtable<Object, Serializable> _map = new Hashtable();

    public ContextLookup(ShadowLookup shadowLookup) {
        Enumeration<ShadowPlace> places = shadowLookup.allPlaces();
        while (places.hasMoreElements()) {
            ShadowPlace shadowPlace = places.nextElement();
            Place place = shadowLookup.get(shadowPlace);
            this._map.put(shadowPlace.getContext(), place);
        }
        Enumeration<ShadowTransition> transitions = shadowLookup.allTransitions();
        while (transitions.hasMoreElements()) {
            ShadowTransition shadowTransition = transitions.nextElement();
            Transition transition = shadowLookup.get(shadowTransition);
            this._map.put(shadowTransition.getContext(), transition);
        }
    }

    public Place getPlace(Object context) {
        return (Place)this._map.get(context);
    }

    public Transition getTransition(Object context) {
        return (Transition)this._map.get(context);
    }

    public Hashtable<Object, Serializable> getMap() {
        return this._map;
    }
}

