/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription.arc;

import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TokenReserver;
import de.renew.net.inscription.arc.ArcRemoveBinder;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Value;

public class InputArcBinder
extends ArcRemoveBinder {
    private final Variable _delayVar;

    protected InputArcBinder(Variable variable, Variable delayVar, SimulatablePlaceInstance placeInstance) {
        super(variable, placeInstance);
        this._delayVar = delayVar;
    }

    private double getDelay() {
        Object timeObj = this._delayVar.getValue();
        if (timeObj instanceof Value) {
            timeObj = ((Value)timeObj).value;
        }
        if (timeObj instanceof Number) {
            return ((Number)timeObj).doubleValue();
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    protected boolean mayBind() {
        return Unify.isBound(this._delayVar);
    }

    @Override
    protected boolean possible(TokenReserver reserver, Object token) {
        double delay = this.getDelay();
        return delay != Double.POSITIVE_INFINITY && reserver.containsRemovableToken(this.getPlaceInstance(), token, delay);
    }

    @Override
    protected boolean remove(TokenReserver reserver, Object token) {
        double delay = this.getDelay();
        return delay != Double.POSITIVE_INFINITY && reserver.removeToken(this.getPlaceInstance(), token, delay);
    }

    @Override
    protected void unremove(TokenReserver reserver, Object token) {
        reserver.unremoveToken(this.getPlaceInstance(), token, this.getDelay());
    }
}

