/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription.arc;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.events.Inhibiting;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.net.PlaceInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.simulatorontology.simulation.StepIdentifier;
import de.renew.unify.Impossible;

class InhibitorExecutable
implements EarlyExecutable {
    private final SimulatablePlaceInstance _placeInstance;
    private final Object _token;
    private final boolean _trace;

    InhibitorExecutable(SimulatablePlaceInstance placeInstance, Object token, boolean trace) {
        this._placeInstance = placeInstance;
        this._token = token;
        this._trace = trace;
    }

    public long lockPriority() {
        return this._placeInstance.getLockOrder();
    }

    @Override
    public int phase() {
        return -4;
    }

    public void lock() {
        this._placeInstance._lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        if (this._placeInstance.containsTestableToken(this._token)) {
            throw new Impossible();
        }
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        if (this._trace) {
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new Inhibiting(this._token, this._placeInstance), (PlaceInstance)this._placeInstance);
        }
    }

    @Override
    public void rollback() {
    }

    public void unlock() {
        this._placeInstance._lock.unlock();
    }
}

