/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.ExpressionWithTypeField;
import de.renew.expression.VariableMapper;
import de.renew.unify.ICalculationChecker;
import de.renew.unify.IStateRecorder;
import de.renew.unify.Impossible;
import de.renew.unify.TypeConstrainer;
import de.renew.unify.Variable;
import de.renew.util.Types;

public class TypeCheckingExpression
extends ExpressionWithTypeField {
    private final Expression _argument;

    public TypeCheckingExpression(Class<?> type, Expression argument) {
        super(type);
        this._argument = argument;
    }

    public Expression getArgument() {
        return this._argument;
    }

    @Override
    public boolean isInvertible() {
        return this._argument.isInvertible();
    }

    @Override
    public Object startEvaluation(VariableMapper mapper, IStateRecorder recorder, ICalculationChecker checker) throws Impossible {
        Object result = this._argument.startEvaluation(mapper, recorder, checker);
        TypeConstrainer.constrain(this.getType(), result, recorder);
        return result;
    }

    @Override
    public Object registerCalculation(VariableMapper mapper, IStateRecorder recorder, ICalculationChecker checker) throws Impossible {
        Variable target = new Variable();
        checker.addCalculated(this.getType(), target, this._argument.registerCalculation(mapper, recorder, checker), recorder);
        return target.getValue();
    }

    public String toString() {
        return "TypeCheckingExpr(" + Types.typeToString((Class)this.getType()) + ": " + String.valueOf(this._argument) + ")";
    }
}

