/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.ExpressionWithTypeField;
import de.renew.expression.VariableMapper;
import de.renew.unify.ICalculationChecker;
import de.renew.unify.IStateRecorder;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Types;

public class EqualsExpression
extends ExpressionWithTypeField {
    private final Expression _left;
    private final Expression _right;

    public EqualsExpression(Class<?> targetType, Expression left, Expression right) {
        super(targetType);
        this._left = left;
        this._right = right;
    }

    @Override
    public boolean isInvertible() {
        return true;
    }

    public Expression getLeft() {
        return this._left;
    }

    public Expression getRight() {
        return this._right;
    }

    @Override
    public Object startEvaluation(VariableMapper mapper, IStateRecorder recorder, ICalculationChecker checker) throws Impossible {
        Variable result = new Variable(this._left.startEvaluation(mapper, recorder, checker), recorder);
        Object rightResult = this._right.startEvaluation(mapper, recorder, checker);
        Unify.unify(result, rightResult, recorder);
        return result.getValue();
    }

    @Override
    public Object registerCalculation(VariableMapper mapper, IStateRecorder recorder, ICalculationChecker checker) throws Impossible {
        Variable result = new Variable(this._left.registerCalculation(mapper, recorder, checker), recorder);
        Object rightObject = this._right.registerCalculation(mapper, recorder, checker);
        checker.addCalculated(this.getType(), result.getValue(), rightObject, recorder);
        return result.getValue();
    }

    public String toString() {
        return "EqualsExpr(" + Types.typeToString((Class)this.getType()) + ": " + String.valueOf(this._left) + " = " + String.valueOf(this._right) + ")";
    }
}

