/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.simulatorontology.simulation.StepIdentifier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.log4j.Logger;

public class StepIdentifierFactory {
    private static final Logger LOGGER = Logger.getLogger(StepIdentifierFactory.class);
    private final long _simulationRunId;
    private long _cycle;

    public StepIdentifierFactory(long simulationRunId) {
        this._simulationRunId = simulationRunId;
        this._cycle = 0L;
    }

    public StepIdentifier nextStepIdentifier() {
        return this.executeInSimulationThread(() -> new StepIdentifier(this._simulationRunId, new long[]{++this._cycle}));
    }

    public StepIdentifier currentStepIdentifier() {
        return this.executeInSimulationThread(() -> new StepIdentifier(this._simulationRunId, new long[]{this._cycle}));
    }

    private StepIdentifier executeInSimulationThread(Supplier<StepIdentifier> supplier) {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(supplier::get);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error((Object)"Interrupted while waiting for simulation thread to finish", (Throwable)e);
            throw new RuntimeException("Simulation thread was interrupted", e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
            throw new RuntimeException("Simulation thread execution failed", e.getCause());
        }
    }
}

