/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.plugin.command.CLCommand;
import de.renew.simulator.api.ISimulationManager;
import de.renew.simulatorontology.simulation.Simulator;
import java.io.PrintStream;
import java.util.Objects;

public class SimulationControlCommand
implements CLCommand {
    private static final String HELP_COMMAND = "help";
    private static final String RUN_COMMAND = "run";
    private static final String STEP_COMMAND = "step";
    private static final String STOP_COMMAND = "stop";
    private static final String HALT_COMMAND = "halt";
    private static final String TERMINATE_COMMAND = "term";
    private final ISimulationManager _simulationManager;

    public SimulationControlCommand(ISimulationManager simulationManager) {
        this._simulationManager = Objects.requireNonNull(simulationManager, "Need ISimulationManager reference.");
    }

    public void execute(String[] args, PrintStream response) {
        if (args == null || args.length != 1 || args[0] == null) {
            response.println("Error: Please give exactly one subcommand. Enter 'help' for a command help.");
        } else {
            this.handleCommand(args[0], response);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleCommand(String command, PrintStream response) {
        Simulator simulator;
        block9: {
            block8: {
                if (command.startsWith(HELP_COMMAND)) {
                    this.showSyntax(response);
                    return;
                }
                if (command.startsWith(TERMINATE_COMMAND)) {
                    this._simulationManager.terminateSimulation();
                    return;
                }
                simulator = this._simulationManager.getCurrentSimulator();
                if (simulator == null) {
                    response.println("Error: There is no current simulation environment.");
                    return;
                }
                if (command.startsWith(RUN_COMMAND)) {
                    SimulationThreadPool.getCurrent().execute(() -> ((Simulator)simulator).startRun());
                    return;
                }
                if (command.startsWith(STEP_COMMAND)) break block8;
                if (!command.isEmpty()) break block9;
            }
            SimulationThreadPool.getCurrent().execute(() -> ((Simulator)simulator).step());
            return;
        }
        if (!command.startsWith(STOP_COMMAND) && !command.startsWith(HALT_COMMAND)) {
            response.println("Error: Unknown command. Enter 'help' for a command help.");
            return;
        }
        SimulationThreadPool.getCurrent().execute(() -> ((Simulator)simulator).stopRun());
    }

    public String getDescription() {
        return String.format("control the simulation by subcommands (e.g. %s, %s, %s)", STEP_COMMAND, RUN_COMMAND, STOP_COMMAND);
    }

    public void showSyntax(PrintStream response) {
        response.println("Simulation control commands:");
        response.println("help   Displays this help.");
        response.println("run    Runs the simulation continuously.");
        response.println("step   Executes only one simulation step.");
        response.println("stop   Stops the simulation, but it remains initialized.");
        response.println("halt   Same as stop.");
        response.println("term   Terminates the simulation.");
    }

    public String getArguments() {
        return String.format("(%s|%s|%s|%s|%s)", RUN_COMMAND, STEP_COMMAND, HALT_COMMAND, TERMINATE_COMMAND, HELP_COMMAND);
    }
}

