/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulatorontology.shadow;

import de.renew.simulatorontology.shadow.ShadowConnection;
import de.renew.simulatorontology.shadow.ShadowInscription;
import de.renew.simulatorontology.shadow.ShadowNode;
import de.renew.simulatorontology.shadow.ShadowPlace;
import de.renew.simulatorontology.shadow.ShadowTransition;
import java.io.IOException;
import java.io.ObjectInputStream;

public class ShadowArc
extends ShadowConnection {
    private static final long serialVersionUID = -774253458615347237L;
    public static final int TEST = 0;
    public static final int ORDINARY = 1;
    public static final int BOTH = 2;
    public static final int INHIBITOR = 3;
    public static final int DOUBLE_ORDINARY = 4;
    public static final int DOUBLE_HOLLOW = 5;
    private final ShadowTransition _transition;
    private final ShadowPlace _place;
    private int _shadowArcType;
    private boolean _placeToTransition;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ShadowArc(ShadowNode from, ShadowNode to, int shadowArcType) {
        super(from, to);
        if (from instanceof ShadowTransition) {
            if (!(to instanceof ShadowPlace)) throw new RuntimeException("Must connect place and transition.");
            this._transition = (ShadowTransition)from;
            this._place = (ShadowPlace)to;
            this._placeToTransition = false;
        } else {
            if (!(from instanceof ShadowPlace)) throw new RuntimeException("Must connect place and transition.");
            if (!(to instanceof ShadowTransition)) throw new RuntimeException("Must connect place and transition.");
            this._place = (ShadowPlace)from;
            this._transition = (ShadowTransition)to;
            this._placeToTransition = true;
        }
        this.setShadowArcType(shadowArcType);
        this.setTrace(true);
        this.getTransition().add(this);
        this.getPlace().add(this);
    }

    public ShadowArc(ShadowNode from, ShadowNode to) {
        this(from, to, 1);
    }

    public ShadowArc(ShadowNode from, ShadowNode to, int shadowArcType, String inscription) {
        this(from, to, shadowArcType);
        new ShadowInscription(this, inscription);
    }

    public ShadowArc(ShadowNode from, ShadowNode to, String inscription) {
        this(from, to, 1, inscription);
    }

    @Override
    public void discard() {
        this.getTransition().remove(this);
        this.getPlace().remove(this);
        super.discard();
    }

    public String toString() {
        return "ShadowArc (type " + this.getShadowArcType() + ", " + String.valueOf(this.getTransition()) + (this.isPlaceToTransition() ? " <- " : " -> ") + String.valueOf(this.getPlace()) + ")";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getTransition().add(this);
        this.getPlace().add(this);
    }

    public int getShadowArcType() {
        return this._shadowArcType;
    }

    public void setShadowArcType(int shadowArcType) {
        this._shadowArcType = shadowArcType;
    }

    public boolean isPlaceToTransition() {
        return this._placeToTransition;
    }

    public ShadowTransition getTransition() {
        return this._transition;
    }

    public ShadowPlace getPlace() {
        return this._place;
    }
}

