/*
 * Decompiled with CFR 0.152.
 */
package de.renew.misc.ant;

import de.renew.call.StubCompiler;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class CreateStubsTask
extends Task {
    private File _destDir = null;
    private Vector<FileSet> _filesets = new Vector();

    public void setDestdir(File dest) {
        this._destDir = dest;
    }

    public void addConfiguredFileset(FileSet fileset) {
        this._filesets.add(fileset);
    }

    public void execute() throws BuildException {
        StubCompiler compiler = new StubCompiler(this._destDir);
        Enumeration<FileSet> enumeration = this._filesets.elements();
        while (enumeration.hasMoreElements()) {
            FileSet fs = enumeration.nextElement();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File dir = ds.getBasedir();
            String[] stubs = ds.getIncludedFiles();
            for (int i = 0; i < stubs.length; ++i) {
                File stub = new File(String.valueOf(dir) + File.separator + stubs[i]);
                try {
                    File target = compiler.compileStub(stub);
                    this.log("stub " + String.valueOf(target) + " generated.");
                    continue;
                }
                catch (Exception e) {
                    throw new BuildException("Stub file '" + String.valueOf(stub) + "' could not be generated:" + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

