/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.standard.AbstractLocator;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

public class RelativeLocator
extends AbstractLocator {
    private static final long serialVersionUID = 2619148876087898602L;
    private final int _relativeLocatorSerializedDataVersion = 1;
    double _relativeX;
    double _relativeY;

    public RelativeLocator() {
        this._relativeX = 0.0;
        this._relativeY = 0.0;
    }

    public RelativeLocator(double relativeX, double relativeY) {
        this._relativeX = relativeX;
        this._relativeY = relativeY;
    }

    @Override
    public Point locate(Figure owner) {
        Rectangle r = owner.displayBox();
        return new Point(r.x + (int)((double)r.width * this._relativeX), r.y + (int)((double)r.height * this._relativeY));
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeDouble(this._relativeX);
        dw.writeDouble(this._relativeY);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this._relativeX = dr.readDouble();
        this._relativeY = dr.readDouble();
    }

    public static Locator east() {
        return new RelativeLocator(1.0, 0.5);
    }

    public static Locator north() {
        return new RelativeLocator(0.5, 0.0);
    }

    public static Locator west() {
        return new RelativeLocator(0.0, 0.5);
    }

    public static Locator northEast() {
        return new RelativeLocator(1.0, 0.0);
    }

    public static Locator northWest() {
        return new RelativeLocator(0.0, 0.0);
    }

    public static Locator south() {
        return new RelativeLocator(0.5, 1.0);
    }

    public static Locator southEast() {
        return new RelativeLocator(1.0, 1.0);
    }

    public static Locator southWest() {
        return new RelativeLocator(0.0, 1.0);
    }

    public static Locator center() {
        return new RelativeLocator(0.5, 0.5);
    }
}

