/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.standard.AbstractTool;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingEditor;
import java.awt.event.MouseEvent;

public class DragTracker
extends AbstractTool {
    protected Figure fAnchorFigure;
    private int _lastX;
    private int _lastY;
    private boolean _moved = false;

    public DragTracker(DrawingEditor editor, Figure anchor) {
        super(editor);
        this.fAnchorFigure = anchor;
        this.editor().prepareUndoSnapshot();
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        this._lastX = x;
        this._lastY = y;
        if (e.isShiftDown()) {
            this.view().toggleSelection(this.fAnchorFigure);
            this.fAnchorFigure = null;
        } else if (!this.view().selection().contains(this.fAnchorFigure)) {
            this.view().clearSelection();
            this.view().addToSelection(this.fAnchorFigure);
        }
        this.altKeyBehavior(e);
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        boolean bl = this._moved = Math.abs(x - this._anchorX) > 4 || Math.abs(y - this._anchorY) > 4;
        if (this._moved) {
            this.drag(x - this._lastX, y - this._lastY);
        }
        this._lastX = x;
        this._lastY = y;
        this.altKeyBehavior(e);
    }

    protected void drag(int dx, int dy) {
        this.view().moveSelection(dx, dy);
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        if (this._moved) {
            this.editor().commitUndoSnapshot();
        }
        super.mouseUp(e, x, y);
    }

    public void altKeyBehavior(MouseEvent e) {
        if (this.fAnchorFigure != null) {
            if (e.isAltDown()) {
                this.fAnchorFigure.setAttribute("MoveWithChildren", true);
            } else {
                this.fAnchorFigure.setAttribute("MoveWithChildren", null);
            }
        }
    }
}

