/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.FloatingTextField;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingEditor;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;

public class TextTool
extends CreationTool {
    protected FloatingTextField _textField;
    private TextHolder _typingTarget;

    public TextTool(DrawingEditor editor, TextFigure prototype) {
        super(editor, prototype);
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        TextHolder textHolder = null;
        Figure pressedFigure = this.drawing().findFigureInside(x, y);
        if (pressedFigure instanceof TextHolder && !(textHolder = (TextHolder)((Object)pressedFigure)).acceptsTyping()) {
            textHolder = null;
        }
        if (textHolder != null) {
            this.beginEdit(textHolder);
            return;
        }
        if (this._typingTarget != null) {
            this.endEdit();
            this.editor().toolDone();
        } else {
            super.mouseDown(e, x, y);
            textHolder = (TextHolder)((Object)this.createdFigure());
            this.beginEdit(textHolder);
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.endEdit();
    }

    @Override
    public void activate() {
        super.activate();
    }

    protected boolean isTypingActive() {
        return this._typingTarget != null;
    }

    public void beginEdit(TextHolder figure) {
        if (this._textField == null) {
            this._textField = new FloatingTextField();
            this._textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 10) {
                        TextTool.this.deactivate();
                        TextTool.this.editor().toolDone();
                    }
                }
            });
        }
        if (figure != this._typingTarget && this._typingTarget != null) {
            this.endEdit();
        }
        this._textField.setText(figure.getText());
        figure.setText("");
        Rectangle bounds = this.fieldBounds(figure);
        Font font = figure.getFont();
        AffineTransform affineTransform = this.view().getAffineTransform();
        if (affineTransform != null) {
            Point p = new Point(bounds.x, bounds.y);
            affineTransform.transform(p, p);
            bounds = new Rectangle(p.x, p.y, 0, 0);
            font = font.deriveFont(affineTransform);
        }
        this._textField.createOverlay((Container)((Object)this.view()), bounds, font);
        this._typingTarget = figure;
        this.view().checkDamage();
    }

    public void setCaretPosition(int line, int col) {
        this._textField.setCaretPosition(line, col);
    }

    public void select(int startLine, int startColumn, int endLine, int endColumn) {
        this._textField.select(startLine, startColumn, endLine, endColumn);
    }

    public void endEdit() {
        if (this._typingTarget != null) {
            String newText = this._textField.getText();
            String oldText = this._typingTarget.getText();
            this._typingTarget.setText(newText);
            if (newText.trim().isEmpty()) {
                this.drawing().remove((Figure)((Object)this._typingTarget));
            }
            this._typingTarget = null;
            this._textField.endOverlay();
            this.view().checkDamage();
            if (!oldText.equals(newText)) {
                this.changesMade();
                this.intermediateUndoSnapshot();
            } else {
                this.noChangesMade();
            }
        }
    }

    private Rectangle fieldBounds(TextHolder figure) {
        return figure.textDisplayBox();
    }
}

