/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.standard.BoxHandleKit;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.FigureHandle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Vector;

public class RectangleFigure
extends AttributeFigure {
    private static final long serialVersionUID = 184722075881789163L;
    private Rectangle _displayBox;
    private final int _rectangleFigureSerializedDataVersion = 1;

    public RectangleFigure() {
        this(new Point(0, 0), new Point(0, 0));
    }

    public RectangleFigure(Point origin, Point corner) {
        this.basicDisplayBox(origin, corner);
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        this._displayBox = new Rectangle(origin);
        this._displayBox.add(corner);
    }

    @Override
    public Vector<FigureHandle> handles() {
        Vector<FigureHandle> handles = new Vector<FigureHandle>();
        BoxHandleKit.addHandles(this, handles);
        return handles;
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this._displayBox.x, this._displayBox.y, this._displayBox.width, this._displayBox.height);
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        this._displayBox.translate(x, y);
    }

    @Override
    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        Graphics2D g2 = (Graphics2D)g;
        Rectangle2D.Float s = new Rectangle2D.Float(r.x, r.y, r.width, r.height);
        g2.fill(s);
    }

    @Override
    public void drawFrame(Graphics g) {
        Rectangle r = this.displayBox();
        Graphics2D g2 = (Graphics2D)g;
        Rectangle2D.Float s = new Rectangle2D.Float(r.x, r.y, r.width, r.height);
        g2.draw(s);
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this._displayBox.x);
        dw.writeInt(this._displayBox.y);
        dw.writeInt(this._displayBox.width);
        dw.writeInt(this._displayBox.height);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this._displayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
    }
}

