/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import de.renew.draw.storables.ontology.Storable;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class FigureAttributes
implements Cloneable,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(FigureAttributes.class);
    private static final long serialVersionUID = -6886355144423666716L;
    private Hashtable<String, Object> _map = new Hashtable();
    private final int _figureAttributesSerializedDataVersion = 1;

    public Object get(String name) {
        return this._map.get(name);
    }

    public void set(String name, Object value) {
        if (value == null) {
            this._map.remove(name);
        } else {
            this._map.put(name, value);
        }
    }

    public boolean hasDefined(String name) {
        return this._map.containsKey(name);
    }

    public Enumeration<String> definedAttributes() {
        return this._map.keys();
    }

    public Object clone() {
        try {
            FigureAttributes a = (FigureAttributes)super.clone();
            a._map = new Hashtable<String, Object>(this._map);
            return a;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void read(StorableInput dr) throws IOException {
        String s = dr.readString();
        if (!"attributes".equalsIgnoreCase(s)) {
            throw new IOException("Attributes expected");
        }
        int version = dr.getVersion();
        int size = dr.readInt();
        int i = 0;
        while (true) {
            block20: {
                if (i >= size) {
                    return;
                }
                String key = dr.readString();
                String valType = dr.readString();
                Object val = null;
                switch (valType) {
                    case "Color": {
                        if (version < 11) {
                            val = new Color(dr.readInt(), dr.readInt(), dr.readInt());
                            break;
                        }
                        val = new Color(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
                        break;
                    }
                    case "Boolean": {
                        val = Boolean.valueOf(dr.readString());
                        break;
                    }
                    case "String": {
                        val = dr.readString();
                        break;
                    }
                    case "Int": {
                        val = dr.readInt();
                        break;
                    }
                    case "Storable": {
                        val = dr.readStorable();
                        break;
                    }
                    case "UNKNOWN": {
                        break block20;
                    }
                }
                this._map.put(key, val);
            }
            ++i;
        }
    }

    public void write(StorableOutput dw) {
        dw.writeString("attributes");
        dw.writeInt(this._map.size());
        Enumeration<String> k = this._map.keys();
        while (k.hasMoreElements()) {
            String s = k.nextElement();
            dw.writeString(s);
            Object v = this._map.get(s);
            if (v instanceof String) {
                dw.writeString("String");
                dw.writeString((String)v);
                continue;
            }
            if (v instanceof Color) {
                dw.writeString("Color");
                dw.writeInt(((Color)v).getRed());
                dw.writeInt(((Color)v).getGreen());
                dw.writeInt(((Color)v).getBlue());
                dw.writeInt(((Color)v).getAlpha());
                continue;
            }
            if (v instanceof Boolean) {
                dw.writeString("Boolean");
                if (((Boolean)v).booleanValue()) {
                    dw.writeString("TRUE");
                    continue;
                }
                dw.writeString("FALSE");
                continue;
            }
            if (v instanceof Integer) {
                dw.writeString("Int");
                dw.writeInt((Integer)v);
                continue;
            }
            if (v instanceof Storable) {
                dw.writeString("Storable");
                dw.writeStorable((Storable)v);
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(FigureAttributes.class.getSimpleName() + ": Unknown attribute type: " + String.valueOf(v)));
            }
            dw.writeString("UNKNOWN");
        }
    }
}

