/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PieFigure;
import CH.ifa.draw.standard.ChopBoxConnector;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.Figure;
import java.awt.Point;
import java.awt.Rectangle;
import org.apache.log4j.Logger;

public class ChopPieConnector
extends ChopBoxConnector {
    public static final Logger LOGGER = Logger.getLogger(ChopPieConnector.class);
    private PieFigure _pieFig;

    public ChopPieConnector() {
    }

    public ChopPieConnector(PieFigure owner) {
        super(owner);
        this._pieFig = owner;
    }

    @Override
    protected Point chop(Figure target, Rectangle source) {
        Rectangle r = target.displayBox();
        Point from = Geom.center(source);
        double angleRad = Geom.pointToAngle(r, from) + (r.intersection(source).equals(r) ? Math.PI : 0.0);
        if (this._pieFig != null) {
            double angleDeg;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Chopping for pieFig=" + String.valueOf(this._pieFig) + ", given target=" + String.valueOf(target) + ", given source=" + String.valueOf(source) + "."));
            }
            double chosenAngle = angleDeg = PieFigure.normalizeAngle(-Math.toDegrees(angleRad));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("   Angles are: angle_rad=" + angleRad + ", angle_deg=" + angleDeg + ", pieFig.getStartAngle()=" + this._pieFig.getStartAngle() + ", pieFig.getEndAngle()=" + this._pieFig.getEndAngle() + "."));
            }
            if (this._pieFig.getStartAngle() < this._pieFig.getEndAngle()) {
                LOGGER.debug((Object)"   start < end");
                if (angleDeg < this._pieFig.getStartAngle()) {
                    LOGGER.debug((Object)"   angle < start < end");
                    chosenAngle = this._pieFig.getStartAngle() - angleDeg < angleDeg + 360.0 - this._pieFig.getEndAngle() ? this._pieFig.getStartAngle() : this._pieFig.getEndAngle();
                } else if (this._pieFig.getEndAngle() < angleDeg) {
                    LOGGER.debug((Object)"   start < end < angle");
                    chosenAngle = this._pieFig.getStartAngle() + 360.0 - angleDeg < angleDeg - this._pieFig.getEndAngle() ? this._pieFig.getStartAngle() : this._pieFig.getEndAngle();
                }
            } else if (this._pieFig.getStartAngle() > this._pieFig.getEndAngle() && this._pieFig.getStartAngle() > angleDeg && angleDeg > this._pieFig.getEndAngle()) {
                LOGGER.debug((Object)"   end < angle < start");
                chosenAngle = this._pieFig.getStartAngle() - angleDeg < angleDeg - this._pieFig.getEndAngle() ? this._pieFig.getStartAngle() : this._pieFig.getEndAngle();
            }
            if (chosenAngle != angleDeg) {
                angleRad = -Math.toRadians(chosenAngle);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("   chosen angle is: deg=" + chosenAngle + ", rad=" + angleRad + "."));
                }
            } else {
                LOGGER.debug((Object)"   chosen angle is unchanged.");
            }
        }
        return Geom.ovalAngleToPoint(r, angleRad);
    }
}

