/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.util.GUIProperties;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.util.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DrawingLoadClient {
    public static Logger logger = Logger.getLogger(DrawingLoadClient.class);

    DrawingLoadClient() {
    }

    public static void loadDrawings(String[] fileName) {
        int serverPort = GUIProperties.loadServerPort();
        if (serverPort == -1) {
            logger.error((Object)"No port specified, please set property de.renew.loadServerPort.");
            System.exit(1);
        }
        try {
            Socket s = new Socket("127.0.0.1", serverPort);
            PrintWriter toSocket = new PrintWriter(s.getOutputStream());
            logger.info((Object)("Passing file names to " + String.valueOf(s.getInetAddress()) + ":" + s.getPort() + "..."));
            for (String string : fileName) {
                toSocket.println(StringUtil.makeCanonical((String)string));
            }
            toSocket.close();
            s.close();
        }
        catch (UnknownHostException e1) {
            logger.error((Object)"localhost (127.0.0.1) not found. Please set up TCP/IP correctly.");
            System.exit(2);
        }
        catch (IOException e2) {
            logger.error((Object)("Probably no server is running, or the DrawingLoadServer is not running on port " + serverPort + "? Exception:\n" + String.valueOf(e2)));
            System.exit(2);
        }
    }

    public static void main(String[] argc) {
        PluginManager.configureLogging();
        GUIProperties.setProperties((Properties)PluginProperties.getUserProperties());
        DrawingLoadClient.loadDrawings(argc);
    }
}

