/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.expression.ConstantExpression;
import de.renew.expression.Expression;
import de.renew.formalism.java.ArcFactory;
import de.renew.formalism.java.ArcInscription;
import de.renew.formalism.java.JavaNetHelper;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.inscription.TransitionInscription;
import de.renew.net.inscription.arc.Arc;
import de.renew.simulatorontology.shadow.SyntaxException;

public class SimpleArcFactory
implements ArcFactory {
    protected Arc.Type _arcType;
    protected boolean _allowsTime;

    public SimpleArcFactory(Arc.Type arcType, boolean allowsTime) {
        this._arcType = arcType;
        this._allowsTime = allowsTime;
    }

    @Override
    public void emptyArcCheck() {
    }

    @Override
    public boolean allowsTime() {
        return this._allowsTime;
    }

    protected Arc getArc(Place place, Transition transition, Arc.Type arcType, Expression expr, Expression timeExpr) {
        return new Arc(place, transition, arcType, expr, timeExpr);
    }

    @Override
    public void compileArc(Place place, Transition transition, boolean trace, Class<?> placeType, ArcInscription insc) throws SyntaxException {
        Expression expr = this._arcType == Arc.Type.OUT ? JavaNetHelper.makeCastedOutputExpression(placeType, insc.getExpression()) : JavaNetHelper.makeCastedInputExpression(placeType, insc.getExpression());
        Expression timeExpr = null;
        if (this._allowsTime) {
            timeExpr = insc.isTimed() ? insc.getTime().getExpression() : ConstantExpression.DOUBLE_ZERO_EXPRESSION;
        }
        Arc arc = this.getArc(place, transition, this._arcType, expr, timeExpr);
        arc.setTrace(trace);
        transition.add((TransitionInscription)arc);
    }
}

