/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.formalism.function.CastFunction;
import de.renew.formalism.java.ArcFactory;
import de.renew.formalism.java.ArcInscription;
import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.TypedExpression;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.inscription.TransitionInscription;
import de.renew.net.inscription.arc.FlexibleArc;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.renew.unify.List;
import de.renew.util.Types;
import java.util.Collection;

public class FlexibleInArcFactory
implements ArcFactory {
    public static FlexibleInArcFactory _instance = new FlexibleInArcFactory();

    private FlexibleInArcFactory() {
    }

    @Override
    public void emptyArcCheck() throws SyntaxException {
        throw new SyntaxException("Flexible arcs must be inscribed.");
    }

    @Override
    public boolean allowsTime() {
        return false;
    }

    @Override
    public void compileArc(Place place, Transition transition, boolean trace, Class<?> placeType, ArcInscription insc) throws SyntaxException {
        TypedExpression typedExpr = insc.getExpression();
        CastFunction forwardFunction = null;
        CastFunction backwardFunction = null;
        Class<?> exprType = typedExpr.getType();
        if (exprType != Types.UNTYPED) {
            if (exprType == null) {
                throw new SyntaxException("Null not allowed for flexible arcs.");
            }
            if (!(List.class.isAssignableFrom(exprType) || Collection.class.isAssignableFrom(exprType) || exprType.isArray())) {
                throw new SyntaxException("Incorrect type for flexible arc inscription.");
            }
        }
        if (placeType != Types.UNTYPED && exprType.isArray()) {
            Class<?> elementType = exprType.getComponentType();
            if (!Types.allowsLosslessWidening(placeType, elementType) && !Types.allowsLosslessWidening(elementType, placeType)) {
                throw new SyntaxException("Cannot losslessly convert " + JavaHelper.makeTypeErrorString(placeType) + " to " + JavaHelper.makeTypeErrorString(elementType) + " or vice versa.");
            }
            forwardFunction = new CastFunction(placeType);
            backwardFunction = new CastFunction(elementType);
        }
        FlexibleArc arc = new FlexibleArc(place, transition, FlexibleArc.IN, typedExpr.getExpression(), forwardFunction, backwardFunction);
        arc.setTrace(trace);
        transition.add((TransitionInscription)arc);
    }
}

