/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayerCollection
implements Iterable<DockableDisplayer> {
    private DockStation station;
    private DockController controller;
    private DisplayerFactory factory;
    private List<Handle> displayers = new ArrayList<Handle>();
    private List<DockableDisplayerListener> listeners = new ArrayList<DockableDisplayerListener>();
    private String displayerId;

    public DisplayerCollection(DockStation station, DisplayerFactory factory, String displayerId) {
        if (station == null) {
            throw new IllegalArgumentException("Station must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        if (displayerId == null) {
            throw new IllegalArgumentException("displayerId must not be null");
        }
        this.station = station;
        this.factory = factory;
        this.displayerId = displayerId;
    }

    public DisplayerCollection(DockStation station, final DefaultDisplayerFactoryValue factory, String displayerId) {
        this(station, new DisplayerFactory(){

            public void request(DisplayerRequest request) {
                factory.request(request);
            }
        }, displayerId);
    }

    public void addDockableDisplayerListener(DockableDisplayerListener listener) {
        this.listeners.add(listener);
        for (DockableDisplayer displayer : this) {
            displayer.addDockableDisplayerListener(listener);
        }
    }

    public void removeDockableDisplayerListener(DockableDisplayerListener listener) {
        this.listeners.remove(listener);
        for (DockableDisplayer displayer : this) {
            displayer.removeDockableDisplayerListener(listener);
        }
    }

    public boolean isDisplayerComponent(Component component) {
        for (DockableDisplayer displayer : this) {
            if (displayer.getComponent() != component) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<DockableDisplayer> iterator() {
        return new Iterator<DockableDisplayer>(){
            private Iterator<Handle> handles;
            {
                this.handles = DisplayerCollection.this.displayers.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.handles.hasNext();
            }

            @Override
            public DockableDisplayer next() {
                return (DockableDisplayer)this.handles.next().getAnswer();
            }

            @Override
            public void remove() {
                this.handles.remove();
            }
        };
    }

    public DockableDisplayer fetch(Dockable dockable, DockTitle title) {
        Handle handle = new Handle(dockable);
        handle.setController(this.controller);
        handle.request(title);
        DockableDisplayer displayer = (DockableDisplayer)handle.getAnswer();
        displayer.setDockable(dockable);
        displayer.setTitle(title);
        displayer.setStation(this.station);
        this.displayers.add(handle);
        for (DockableDisplayerListener listener : this.listeners) {
            displayer.addDockableDisplayerListener(listener);
        }
        return displayer;
    }

    public void release(DockableDisplayer displayer) {
        for (DockableDisplayerListener listener : this.listeners) {
            displayer.removeDockableDisplayerListener(listener);
        }
        Iterator<DockableDisplayer> iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != displayer) continue;
            iter.remove();
        }
        displayer.setTitle(null);
        displayer.setDockable(null);
        displayer.setStation(null);
        displayer.setController(null);
    }

    public void setFactory(DisplayerFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.factory = factory;
    }

    public void setController(DockController controller) {
        if (this.controller != controller) {
            this.controller = controller;
            for (Handle handle : this.displayers) {
                handle.setController(controller);
            }
        }
    }

    private class Handle
    extends DisplayerRequest {
        public Handle(Dockable target) {
            super(DisplayerCollection.this.station, target, new DisplayerFactory(){

                public void request(DisplayerRequest request) {
                    DisplayerCollection.this.factory.request(request);
                }
            }, DisplayerCollection.this.displayerId);
        }

        public void setController(DockController controller) {
            super.setController(controller);
            DockableDisplayer displayer = (DockableDisplayer)this.getAnswer();
            if (displayer != null) {
                displayer.setController(null);
            }
        }

        protected void answer(DockableDisplayer previousResource, DockableDisplayer newResource) {
            if (previousResource != null) {
                previousResource.setController(null);
            }
            if (newResource != null) {
                newResource.setController(this.getController());
            }
        }
    }
}

