/*
 * Decompiled with CFR 0.152.
 */
package de.renew.tablet.tools;

import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.standard.UndoableTool;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingEditor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;

public class ScribbleTool
extends UndoableTool {
    private PolyLineFigure _fScribble;
    private int _fLastX;
    private int _fLastY;

    public ScribbleTool(DrawingEditor editor) {
        super(editor);
    }

    public void activate() {
        super.activate();
        this._fScribble = null;
    }

    public void deactivate() {
        if (this._fScribble != null && (this._fScribble.size().width < 4 || this._fScribble.size().height < 4)) {
            this.drawing().remove((Figure)this._fScribble);
            this.noChangesMade();
        }
        this._fScribble = null;
        super.deactivate();
    }

    private void point(int x, int y) {
        AffineTransform at = this.view().getAffineTransform();
        if (at != null) {
            try {
                Point p = new Point(x, y);
                at.inverseTransform(p, p);
                x = p.x;
                y = p.y;
            }
            catch (NoninvertibleTransformException e) {
                System.err.println("DrawingView for drawing " + this.view().drawing().getName() + " had an irreversible affine transformation.");
                System.err.println("The polyline was not correctly scaled.");
                e.printStackTrace();
            }
        }
        if (this._fScribble == null) {
            this._fScribble = new PolyLineFigure(x, y);
            this.view().add((Figure)this._fScribble);
            this.changesMade();
        } else if (this._fLastX != x || this._fLastY != y) {
            this._fScribble.addPoint(x, y);
        }
        this._fLastX = x;
        this._fLastY = y;
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        if (e.getClickCount() >= 2) {
            this.editor().toolDone();
        } else {
            this.point(e.getX(), e.getY());
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this._fScribble != null) {
            this.point(e.getX(), e.getY());
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        this._fScribble = null;
    }
}

