/*
 * Decompiled with CFR 0.152.
 */
package de.renew.tablet;

import CH.ifa.draw.util.Palette;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.Tool;
import de.renew.gui.GuiPlugin;
import de.renew.gui.PaletteHolder;
import de.renew.tablet.tools.PTToggleCreationTool;
import de.renew.tablet.tools.ScribbleTool;
import org.apache.log4j.Logger;

public class PaletteCreator {
    private static final Logger LOGGER = Logger.getLogger(PaletteCreator.class);
    private Palette _palette;
    private String _label;

    public PaletteCreator(String name) {
        this.create(name);
    }

    void create(String paletteName) {
        GuiPlugin starter = GuiPlugin.getCurrent();
        PaletteHolder paletteHolder = starter.getPaletteHolder();
        String images = "/de/renew/tablet/images/";
        this._palette = new Palette(paletteName);
        DrawingEditor editor = starter.getDrawingEditor();
        Object tool = new ScribbleTool(editor);
        this._palette.add(paletteHolder.createToolButton(images + "scribble", "tablet scribble", (Tool)tool));
        tool = new PTToggleCreationTool(editor);
        this._palette.add(paletteHolder.createToolButton(images + "toggle", "toggle p / t", (Tool)tool));
        paletteHolder.addPalette(this._palette);
    }

    public void remove() {
        GuiPlugin starter = GuiPlugin.getCurrent();
        if (starter == null) {
            return;
        }
        starter.getPaletteHolder().removePalette(this._palette);
    }

    public String getLabel() {
        return this._label;
    }

    public String toString() {
        return this.getLabel();
    }
}

