<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# Refactoring

## User Guide

_Refactoring_ enables the user to refactor variables and channels.

### Features

- Refactor variables and channels in net instances
- Refactor channels across multiple nets

### Example Usage

1. Open a net in the graphical editor.
2. Select a channel or variable you want to refactor.
3. Select refactor via tools -> refactor.
4. Depending on whether you selected a variable or channel choose "Rename channel" or "Rename variable"
5. If you chose to rename a variable just enter the desired name and the variable name will be updated in the whole net
6. If you chose to rename a channel, enter the desired name and chose in which scope the channel should be renamed
7. Click next
8. Now you can see which channels in which drawing will be affected
9. Click on preview to see the changes
10. Decide if you want to keep these changes or cancel them

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->
_Refactoring_ does not provide CLCommands.

### Installation

Install _Refactoring_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew.


### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Gui`: Multiple uses for example to get the drawings that are currently loaded in the gui
- `log4j`: Logging framework

### Configuration

During the initialization of _Refactoring_, no properties are read from the `renew.properties` file in the Renew root directory.

## Developer Guide

### Core Classes

- `RefactoringPlugin`: extends `PluginAdapter`, which implements the `IPlugin` interface to manage the startup and shutdown.

### How to Extend

_Refactoring_ exposes multiple Interfaces: 

- `Editor`: Interface for editors that perform edits similarly to an `Iterator`.
- `InlineController`: Interface for inline controllers.
- `InlineListener`: Interface for inline listeners.
- `InlineStep`:Interface for inline steps.
- `InlineStepListener`: Interface for inline step listeners.
- `NameFinder`: Interface for name finders.
- `LinkParser`: Interface for parsers for uplinks and downlinks.
- `VariableParser`: Interface for variable parsers.
- `DrawingSearchRange`: Interface for drawing search ranges.
- `FileSearchRange`: Interface for file search ranges.
- `SearchRange`: Base interface for search ranges that only requires a description. This interface should only be used in a GUI search range picker. In almost all cases, `DrawingSearchRange` or `FileSearchRange` should be implemented instead of this interface.
- `Searcher`: Interface for searchers.
- `WizardButtons`:Interface for wizard buttons.
- `WizardListener`: Interface for wizard listeners.

You can implement these interfaces to add additional functionality to the plugin.

### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

<!-- Contribution Info -->
Original author: 2mfriedr
<!-- License -->
