/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamevariable;

import CH.ifa.draw.figures.TextFigure;
import de.renew.refactoring.edit.TextFigureMatchEditor;
import de.renew.refactoring.renamevariable.VariableNameMatch;
import de.renew.refactoring.util.StringHelper;
import java.util.List;
import org.apache.log4j.Logger;

class RenameVariableEditor
extends TextFigureMatchEditor<VariableNameMatch, Void> {
    private static final Logger LOGGER = Logger.getLogger(RenameVariableEditor.class);
    final String _newName;

    RenameVariableEditor(List<VariableNameMatch> references, String newName) {
        super(references);
        this._newName = newName;
    }

    @Override
    protected Void performEdit(VariableNameMatch match) {
        TextFigure textFigure = match.getTextFigure();
        String text = textFigure.getText();
        int nameStart = match.getStart();
        int nameEnd = match.getEnd();
        String newText = StringHelper.replaceRange(text, nameStart, nameEnd, this._newName);
        LOGGER.debug((Object)("Replaced variable: " + newText));
        this.changeText(match, newText);
        return null;
    }
}

