/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamechannel;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.refactoring.match.DownlinkMatch;
import de.renew.refactoring.match.LinkMatch;
import de.renew.refactoring.match.UplinkMatch;
import de.renew.refactoring.parse.LinkParser;
import de.renew.refactoring.renamechannel.NoLinkSelectedException;
import de.renew.refactoring.renamechannel.RenameChannelRefactoring;
import de.renew.refactoring.search.range.DrawingSearchRange;
import de.renew.refactoring.search.range.SearchRange;
import de.renew.refactoring.search.range.SearchRanges;
import de.renew.refactoring.wizard.ComboBoxPanel;
import de.renew.refactoring.wizard.DrawingListPanel;
import de.renew.refactoring.wizard.ProgressBarWizardPage;
import de.renew.refactoring.wizard.SearchRangeSelectPanel;
import de.renew.refactoring.wizard.SelectMatchesTable;
import de.renew.refactoring.wizard.TableSelectButton;
import de.renew.refactoring.wizard.TextFieldPanel;
import de.renew.refactoring.wizard.WizardController;
import de.renew.refactoring.wizard.WizardPage;
import de.renew.refactoring.wizard.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class RenameChannelWizardController
extends WizardController {
    private static final Logger LOGGER = Logger.getLogger(RenameChannelWizardController.class);
    private State _state = State.STARTED;
    private final RenameChannelRefactoring _refactoring;
    private final Map<SearchRange, List<LinkMatch>> _matches;
    static final String SELECT_LINK_PAGE = "SELECT_LINK_PAGE";
    static final String ENTER_NEW_CHANNEL_NAME_PAGE = "ENTER_NEW_CHANNEL_NAME_PAGE";
    static final String SELECT_MATCHES_PAGE = "SELECT_MATCHES_PAGE";
    static final String FINISH_PAGE = "FINISH_PAGE";
    static final int CHECKBOX_COLUMN = 0;
    static final int NET_NAME_COLUMN = 1;
    static final int CONTEXT_COLUMN = 2;
    static final int LINKMATCH_OBJECT_COLUMN = 3;
    static final int NUMBER_OF_COLUMNS = 4;

    public RenameChannelWizardController(LinkParser parser, Drawing drawing, List<Figure> selection) throws NoLinkSelectedException {
        this._refactoring = new RenameChannelRefactoring(parser, drawing, selection);
        this._matches = new HashMap<SearchRange, List<LinkMatch>>();
    }

    @Override
    public String getTitle() {
        return "Rename Channel";
    }

    @Override
    public WizardPage getNextPage() {
        ProgressBarWizardPage<List<Drawing>> page;
        if (this._state == State.STARTED) {
            List<LinkMatch> links = this._refactoring.getSelectedLinks();
            if (links.size() > 1) {
                return this.makeSelectLinkPage(links);
            }
            this._refactoring.setSelectedLink(links.get(0));
            this._state = State.SELECTED_LINK;
        }
        if (this._state == State.SELECTED_LINK) {
            return this.makeEnterNewChannelNamePage(this._refactoring.getOldChannelName(), this._refactoring.getParameterCount());
        }
        if (this._state == State.ENTERED_NEW_CHANNEL_NAME) {
            page = this.makeSelectMatchesPage();
            SwingWorker<List<LinkMatch>, Void> worker = this.makeSearchWorker(page);
            worker.execute();
            return page;
        }
        if (this._state == State.SELECTED_MATCHES) {
            page = this.makeFinishPage();
            SwingWorker<List<Drawing>, Void> worker = this.makeEditWorker(page);
            worker.execute();
            return page;
        }
        return null;
    }

    private SwingWorker<List<LinkMatch>, Void> makeSearchWorker(final ProgressBarWizardPage<List<LinkMatch>> page) {
        return new SwingWorker<List<LinkMatch>, Void>(){

            @Override
            protected List<LinkMatch> doInBackground() throws Exception {
                DrawingSearchRange searchRange = RenameChannelWizardController.this._refactoring.getSearchRange();
                if (RenameChannelWizardController.this._matches.containsKey(searchRange)) {
                    return RenameChannelWizardController.this._matches.get(searchRange);
                }
                ArrayList<LinkMatch> matches = new ArrayList<LinkMatch>();
                while (RenameChannelWizardController.this._refactoring.hasNextDrawingToSearch()) {
                    matches.addAll(RenameChannelWizardController.this._refactoring.findLinksInNextDrawing());
                    page.setProgress(RenameChannelWizardController.this._refactoring.getReferencingLinkFinderProgress());
                    page.setStatus("<html>Searching drawing: <i>" + RenameChannelWizardController.this._refactoring.getCurrentlySearchedDrawingName() + "</i></html>");
                }
                RenameChannelWizardController.this._matches.put(searchRange, matches);
                return matches;
            }

            @Override
            protected void done() {
                try {
                    page.done((List)this.get());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    private SwingWorker<List<Drawing>, Void> makeEditWorker(final ProgressBarWizardPage<List<Drawing>> page) {
        return new SwingWorker<List<Drawing>, Void>(){

            @Override
            protected List<Drawing> doInBackground() throws Exception {
                while (RenameChannelWizardController.this._refactoring.hasNextEdit()) {
                    RenameChannelWizardController.this._refactoring.performNextEdit();
                    page.setProgress(RenameChannelWizardController.this._refactoring.getEditorProgress());
                    page.setStatus("<html>Editing file: <i>" + RenameChannelWizardController.this._refactoring.getCurrentlyEditedDrawingName() + "</i></html>");
                }
                return RenameChannelWizardController.this._refactoring.getChangedDrawings();
            }

            @Override
            protected void done() {
                try {
                    page.done((List)this.get());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    private WizardPage makeSelectLinkPage(final List<LinkMatch> links) {
        String intro = "Select the link to rename:";
        return new WizardPage(SELECT_LINK_PAGE){
            ComboBoxPanel<LinkMatch> _comboBox;

            @Override
            protected void didLoad() {
                this._comboBox = new ComboBoxPanel("Select the link to rename:", links);
                this.getPanel().add(this._comboBox);
            }

            @Override
            protected void didAppear() {
                this._comboBox.focus();
                RenameChannelWizardController.this.setNextButtonEnabled(true);
            }

            @Override
            protected void saveState() {
                RenameChannelWizardController.this._refactoring.setSelectedLink(this._comboBox.getInput());
                RenameChannelWizardController.this._state = State.SELECTED_LINK;
            }

            @Override
            protected void resetState() {
                RenameChannelWizardController.this._refactoring.setSelectedLink(null);
                RenameChannelWizardController.this._state = State.STARTED;
            }
        };
    }

    private WizardPage makeEnterNewChannelNamePage(final String oldChannelName, int parameterCount) {
        String parameters = "parameter" + (parameterCount != 1 ? "s" : "");
        final String intro = "<html>Enter the new name for <i>" + oldChannelName + "</i> (" + parameterCount + " " + parameters + "):</html>";
        return new WizardPage(ENTER_NEW_CHANNEL_NAME_PAGE){
            TextFieldPanel _textField;
            SearchRangeSelectPanel _searchRange;

            @Override
            protected void didLoad() {
                this._textField = new TextFieldPanel(intro, oldChannelName){
                    private static final long serialVersionUID = 5496760266040789662L;

                    @Override
                    public void inputChanged(String input) {
                        this.configureNextButton(input);
                    }
                };
                this.getPanel().add(this._textField);
                ArrayList<SearchRange> searchRanges = new ArrayList<SearchRange>(SearchRanges.netDrawingSearchRanges(RenameChannelWizardController.this._refactoring.getInitialDrawing()));
                this._searchRange = new SearchRangeSelectPanel(searchRanges);
                this.getPanel().add(this._searchRange);
            }

            @Override
            protected void didAppear() {
                this._textField.focus();
                this.configureNextButton(this._textField.getInput());
            }

            @Override
            protected void saveState() {
                RenameChannelWizardController.this._refactoring.setSearchRange((DrawingSearchRange)this._searchRange.getValue());
                RenameChannelWizardController.this._refactoring.setNewChannelName(this._textField.getInput());
                RenameChannelWizardController.this._state = State.ENTERED_NEW_CHANNEL_NAME;
            }

            @Override
            protected void resetState() {
                RenameChannelWizardController.this._refactoring.setSearchRange(null);
                RenameChannelWizardController.this._refactoring.setNewChannelName(null);
                RenameChannelWizardController.this._state = State.STARTED;
            }

            private void configureNextButton(String input) {
                RenameChannelWizardController.this.setNextButtonEnabled(RenameChannelWizardController.this._refactoring.isValidChannelName(input));
            }
        };
    }

    private ProgressBarWizardPage<List<LinkMatch>> makeSelectMatchesPage() {
        return new ProgressBarWizardPage<List<LinkMatch>>(SELECT_MATCHES_PAGE){
            List<LinkMatch> _matches;
            SelectMatchesTable<LinkMatch> _table;

            @Override
            protected void didAppear() {
                RenameChannelWizardController.this.setNextButtonEnabled(!this.isInProgress());
            }

            @Override
            protected String nextButtonTitle() {
                return "Preview";
            }

            @Override
            protected void saveState() {
                RenameChannelWizardController.this._refactoring.setLinksToReplace(this._table.getSelectedItems());
                RenameChannelWizardController.this._state = State.SELECTED_MATCHES;
            }

            @Override
            protected void resetState() {
                RenameChannelWizardController.this._refactoring.setLinksToReplace(null);
                RenameChannelWizardController.this._state = State.ENTERED_NEW_CHANNEL_NAME;
            }

            @Override
            protected void progressDone(List<LinkMatch> result) {
                RenameChannelWizardController.this.setNextButtonEnabled(true);
                JPanel panel = this.getPanel();
                panel.setLayout(new BorderLayout(0, 10));
                JLabel intro = new JLabel("Select the links to be replaced:");
                panel.add((Component)intro, "North");
                this._matches = result;
                LinkMatch selected = RenameChannelWizardController.this._refactoring.getSelectedLink();
                Object[][] rowData = this.makeRowData(this._matches, selected);
                String[] columnNames = new String[]{"refactor", "drawing", "context", ""};
                int[] uneditableRows = new int[]{0};
                this._table = new SelectMatchesTable<LinkMatch>(LinkMatch.class, rowData, columnNames, uneditableRows);
                panel.add((Component)new JScrollPane(this._table), "Center");
                JPanel selectButtonsPanel = this.makeSelectButtonsPanel(this._table);
                panel.add((Component)selectButtonsPanel, "South");
                panel.revalidate();
                RenameChannelWizardController.this.focusNextButton();
            }

            private Object[][] makeRowData(List<LinkMatch> matches, LinkMatch selectedLink) {
                Object[][] rowData = new Object[matches.size()][4];
                LOGGER.debug((Object)("Matches size: " + matches.size()));
                boolean foundSelectedLink = false;
                for (int i = 0; i < matches.size(); ++i) {
                    LinkMatch link = matches.get(i);
                    if (link.equals(selectedLink)) {
                        ins = 0;
                        foundSelectedLink = true;
                    } else {
                        ins = foundSelectedLink ? i : i + 1;
                    }
                    rowData[ins] = new Object[4];
                    rowData[ins][0] = Boolean.TRUE;
                    rowData[ins][1] = link.getDrawing().getName();
                    rowData[ins][2] = link.matchWithContext();
                    rowData[ins][3] = link;
                }
                return rowData;
            }

            private JPanel makeSelectButtonsPanel(JTable table) {
                JPanel panel = new JPanel(new WrapLayout());
                panel.add(new JLabel("Select:"));
                panel.add(TableSelectButton.selectAllButton("All", table, 0));
                panel.add(TableSelectButton.selectNoneButton("None", table, 0));
                TableSelectButton uplinksButton = TableSelectButton.selectInstancesButton("Uplinks", UplinkMatch.class, table, 0, 3);
                panel.add(uplinksButton);
                TableSelectButton downlinksButton = TableSelectButton.selectInstancesButton("Downlinks", DownlinkMatch.class, table, 0, 3);
                panel.add(downlinksButton);
                return panel;
            }
        };
    }

    private ProgressBarWizardPage<List<Drawing>> makeFinishPage() {
        return new ProgressBarWizardPage<List<Drawing>>(FINISH_PAGE){

            @Override
            protected void didAppear() {
                RenameChannelWizardController.this.setNextButtonEnabled(!this.isInProgress());
            }

            @Override
            protected boolean isLastPage() {
                return true;
            }

            @Override
            protected void saveState() {
                RenameChannelWizardController.this._refactoring.saveChangedDrawings();
            }

            @Override
            protected void resetState() {
                RenameChannelWizardController.this._refactoring.restorePreviousTexts();
            }

            @Override
            protected void progressDone(List<Drawing> result) {
                RenameChannelWizardController.this._state = State.FINISHED;
                RenameChannelWizardController.this.setNextButtonEnabled(true);
                JPanel panel = this.getPanel();
                panel.setLayout(new BorderLayout());
                panel.add((Component)new DrawingListPanel(result, "Finished. The following drawings will be saved:"), "Center");
            }
        };
    }

    private static enum State {
        STARTED,
        SELECTED_LINK,
        ENTERED_NEW_CHANNEL_NAME,
        SELECTED_MATCHES,
        FINISHED;

    }
}

