/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamechannel;

import CH.ifa.draw.figures.TextFigure;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.refactoring.edit.TextFigureMatchEditor;
import de.renew.refactoring.match.LinkMatch;
import de.renew.refactoring.util.StringHelper;
import java.util.List;
import org.apache.log4j.Logger;

public class RenameChannelEditor
extends TextFigureMatchEditor<LinkMatch, Drawing> {
    private static final Logger LOGGER = Logger.getLogger(RenameChannelEditor.class);
    private final String _newChannelName;

    RenameChannelEditor(List<LinkMatch> linkMatches, String newChannelName) {
        super(linkMatches);
        this._newChannelName = newChannelName;
    }

    @Override
    public Drawing performEdit(LinkMatch match) {
        TextFigure textFigure = match.getTextFigure();
        String text = textFigure.getText();
        String linkString = match.getMatch();
        int channelStart = match.getChannelNameStart();
        int channelEnd = match.getChannelNameEnd();
        String newLink = StringHelper.replaceRange(linkString, channelStart, channelEnd, this._newChannelName);
        LOGGER.debug((Object)("Replaced channel name: " + newLink));
        int linkStart = match.getStart();
        int linkEnd = match.getEnd();
        String newText = StringHelper.replaceRange(text, linkStart, linkEnd, newLink);
        this.changeText(match, newText);
        return match.getDrawing();
    }
}

