/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.parse;

import de.renew.expression.AggregateExpression;
import de.renew.expression.Expression;
import de.renew.expression.LocalVariable;
import de.renew.expression.VariableExpression;
import de.renew.net.inscription.TransitionInscription;
import de.renew.net.inscription.transition.DownlinkInscription;
import de.renew.net.inscription.transition.UplinkInscription;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.JNPParser;
import de.renew.refactoring.parse.LinkInscription;
import de.renew.refactoring.parse.LinkParser;
import de.renew.refactoring.util.StringHelper;
import java.util.ArrayList;
import java.util.List;

public class JNPLinkParser
implements LinkParser {
    private static final String CHANNEL_NAME_ALLOW_ALL = "CHANNEL_NAME_ALLOW_ALL";
    private static final int PARAMETER_COUNT_ALLOW_ALL = -1;

    @Override
    public boolean isValidChannelName(String name) {
        return JNPParser.isIdentifier(JNPParser.netParser(name));
    }

    @Override
    public boolean containsUplink(String string) {
        return JNPLinkParser.containsInscriptionOfType(UplinkInscription.class, string);
    }

    @Override
    public boolean containsDownlink(String string) {
        return JNPLinkParser.containsInscriptionOfType(DownlinkInscription.class, string);
    }

    private static boolean containsInscriptionOfType(Class<?> inscriptionType, String string) {
        for (TransitionInscription inscription : JNPParser.transitionInscriptions(JNPParser.netParser(string))) {
            if (!inscriptionType.isInstance(inscription)) continue;
            return true;
        }
        return false;
    }

    @Override
    public StringMatch findChannelName(String link) {
        try {
            LinkInscription inscription = new LinkInscription(JNPParser.firstInscription(JNPParser.netParser(link)));
            return StringHelper.makeStringMatch(link, inscription.getNameBeginLine(), inscription.getNameBeginColumn(), inscription.getNameEndLine(), inscription.getNameEndColumn());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public int findParameterCount(String link) {
        return JNPLinkParser.findParameterCount(JNPParser.firstInscription(JNPParser.netParser(link)));
    }

    private static int findParameterCount(Object inscription) {
        Expression params = new LinkInscription(inscription).getParams();
        try {
            return ((AggregateExpression)params).getExpressions().length;
        }
        catch (ClassCastException e) {
            return -1;
        }
    }

    @Override
    public boolean isDownlinkToThis(String link) {
        try {
            DownlinkInscription downlinkInscription = (DownlinkInscription)JNPParser.firstInscription(JNPParser.netParser(link));
            VariableExpression variableExpression = (VariableExpression)downlinkInscription.getCallee();
            LocalVariable variable = variableExpression.getVariable();
            return variable.getName().equals("this");
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public StringMatch findUplink(String string) {
        return this.findUplink(string, CHANNEL_NAME_ALLOW_ALL, -1);
    }

    @Override
    public StringMatch findUplink(String string, String channel, int parameterCount) {
        UplinkInscription uplink = null;
        for (TransitionInscription inscription : JNPParser.transitionInscriptions(JNPParser.netParser(string))) {
            if (!(inscription instanceof UplinkInscription)) continue;
            uplink = (UplinkInscription)inscription;
            if (JNPLinkParser.matchesChannelName(uplink, channel) && JNPLinkParser.matchesParameterCount(uplink, parameterCount)) {
                return JNPLinkParser.makeStringMatch(string, uplink);
            }
            return null;
        }
        return null;
    }

    @Override
    public List<StringMatch> findDownlinks(String string) {
        return this.findDownlinks(string, CHANNEL_NAME_ALLOW_ALL, -1);
    }

    @Override
    public List<StringMatch> findDownlinks(String string, String channel, int parameterCount) {
        ArrayList<StringMatch> downlinks = new ArrayList<StringMatch>();
        for (TransitionInscription inscription : JNPParser.transitionInscriptions(JNPParser.netParser(string))) {
            DownlinkInscription downlink;
            if (!(inscription instanceof DownlinkInscription) || !JNPLinkParser.matchesChannelName(downlink = (DownlinkInscription)inscription, channel) || !JNPLinkParser.matchesParameterCount(downlink, parameterCount)) continue;
            if (downlink.getName().equals("new")) break;
            downlinks.add(JNPLinkParser.makeStringMatch(string, downlink));
        }
        return downlinks;
    }

    private static StringMatch makeStringMatch(String string, Object uplinkOrDownlink) {
        LinkInscription inscription = new LinkInscription(uplinkOrDownlink);
        return StringHelper.makeStringMatch(string, inscription.getBeginLine(), inscription.getBeginColumn(), inscription.getEndLine(), inscription.getEndColumn());
    }

    private static boolean matchesChannelName(Object uplinkOrDownlink, String channel) {
        if (channel.equals(CHANNEL_NAME_ALLOW_ALL)) {
            return true;
        }
        LinkInscription inscription = new LinkInscription(uplinkOrDownlink);
        return inscription.getName().equals(channel);
    }

    private static boolean matchesParameterCount(Object uplinkOrDownlink, int parameterCount) {
        if (parameterCount == -1) {
            return true;
        }
        return JNPLinkParser.findParameterCount(uplinkOrDownlink) == parameterCount;
    }
}

