<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# MiniMap

## User Guide

_MiniMap_ is an extension to the GUI that provides an overview of the currently selected net and simplifies navigation in large nets.


### Features

- See the whole net that is currently selected in a small overview
- See which part is displayed by the View
- Click on the mini map to jump to the selected location

### Example Usage

1. Display the mini map via Plugin -> Show MiniMap...
2. Open any net in the graphical editor.
3. Select the net to work on it.
4. The mini map will now provide an overview of the currently selected net.

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->

- `MiniMap` - show the minimap panel

### Installation

Install _MiniMap_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `CH`: Add a drawing window that can be used as an overview
- `docking.frames.common`: Library that provides the used graphical elements
- `log4j`: Logging Framework

### Configuration

During the initialization of MiniMap, no properties are read that could be configured.

## Developer Guide

### Core Classes

- `MiniMapPlugin`: Extends the `DIPlugin` abstract class to manage the startup and shutdown.
- `ShowMiniMapCommand`: Creates the MiniMap Frame and handles requests to display it.
- `MiniMapPanel`: Contains most logic of the Plugin, handles changes to the current net and their display.
Also handles user interactions with the MiniMap.

### How to Extend

_MiniMap_ does not currently support extensions.

