/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.FigureWithID;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.LolaResult;
import de.renew.lola2.analysis.LolaResultStatus;
import de.renew.lola2.analysis.PropertyAnalyzer;
import de.renew.lola2.gui.LolaGUI;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class MarkingEditorPanel
extends JPanel {
    private LolaGUI _lolaGUI;
    private JTable _markingTable;
    private UpdatePlacesAction _updatePlacesListener;
    private JCheckBox _updateInitialMarkingCheckbox = new JCheckBox("Update initial marking", true);
    private static Logger _logger = Logger.getLogger(MarkingEditorPanel.class);

    public MarkingEditorPanel(LolaGUI lolaGUI) {
        this._lolaGUI = lolaGUI;
        this.setVisible(true);
        this.setup();
    }

    private void setup() {
        int numColumns = 3;
        int numRows = 1;
        this._markingTable = new JTable(numRows, numColumns);
        this._markingTable.getColumnModel().getColumn(0).setHeaderValue("Place");
        this._markingTable.getColumnModel().getColumn(1).setHeaderValue("Initial");
        this._markingTable.getColumnModel().getColumn(2).setHeaderValue("Check");
        JScrollPane scrollPane = new JScrollPane(this._markingTable);
        this._markingTable.setFillsViewportHeight(true);
        JButton updateButton = new JButton("Update places!");
        updateButton.setToolTipText("Update the places from the currently active net.");
        JButton reachButton = new JButton("Check reachability!");
        reachButton.setToolTipText("Check if the marking entered into the table can be reached from the initial marking (from the table).");
        JButton homeButton = new JButton("Check home status!");
        homeButton.setToolTipText("Check if the marking entered into the table is a home state w.r.t. the initial marking (from the table).");
        JButton coverButton = new JButton("Check coverability!");
        coverButton.setToolTipText("Check if the marking entered into the table is coverable w.r.t. the initial marking (from the table).");
        this.setLayout(new BorderLayout());
        JPanel sidePanel = new JPanel();
        sidePanel.setLayout(new GridLayout(5, 1));
        this.add("Center", scrollPane);
        this._updatePlacesListener = new UpdatePlacesAction();
        updateButton.addActionListener(this._updatePlacesListener);
        sidePanel.add(updateButton);
        ReachableMarkingAction reachableMarkingListener = new ReachableMarkingAction();
        reachButton.addActionListener(reachableMarkingListener);
        sidePanel.add(reachButton);
        HomeStateMarkingAction homeStateListener = new HomeStateMarkingAction();
        homeButton.addActionListener(homeStateListener);
        sidePanel.add(homeButton);
        CoverableMarkingAction coverabilityListener = new CoverableMarkingAction();
        coverButton.addActionListener(coverabilityListener);
        sidePanel.add(coverButton);
        this._updateInitialMarkingCheckbox.setToolTipText("If this is checked the initial marking will be updated from the net when the places are updated.");
        sidePanel.add(this._updateInitialMarkingCheckbox);
        this.add("East", sidePanel);
    }

    private int findCorrectRow(String value, int column) {
        int result = -1;
        for (int i = 0; i < this._markingTable.getRowCount(); ++i) {
            if (!value.equals(this._markingTable.getValueAt(i, column))) continue;
            result = i;
        }
        return result;
    }

    void updatePlaces() {
        this._updatePlacesListener.actionPerformed(null);
    }

    public String getTableMarking(int column, int mode) {
        String separator = "";
        String comparator = "";
        switch (mode) {
            case 1: {
                separator = " , ";
                comparator = " : ";
                break;
            }
            case 2: {
                separator = " AND ";
                comparator = " >= ";
                break;
            }
            case 3: {
                separator = " AND ";
                comparator = " = ";
            }
        }
        StringBuffer sb = new StringBuffer();
        if (mode == 1) {
            sb.append("MARKING ");
        } else {
            sb.append("(");
        }
        for (int i = 0; i < this._markingTable.getRowCount(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(String.valueOf(this._markingTable.getValueAt(i, 0)) + comparator);
            if (this._markingTable.getValueAt(i, column) != null && !this._markingTable.getValueAt(i, column).equals("")) {
                sb.append(this._markingTable.getValueAt(i, column));
                continue;
            }
            sb.append("0");
        }
        if (mode == 2 || mode == 3) {
            sb.append(")");
        }
        return sb.toString();
    }

    class UpdatePlacesAction
    implements ActionListener {
        UpdatePlacesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LolaFileCreator fileCreator = new LolaFileCreator();
            DrawApplication app = DrawPlugin.getGui();
            if (app.drawing() instanceof CPNDrawing) {
                MarkingEditorPanel.this._lolaGUI._drawing = (CPNDrawing)app.drawing();
            }
            _logger.info((Object)("[Lola] performing updatePlacesAction with drawing " + MarkingEditorPanel.this._lolaGUI._drawing.getName()));
            FigureEnumeration figs = MarkingEditorPanel.this._lolaGUI._drawing.figures();
            DefaultTableModel tableModel = new DefaultTableModel();
            tableModel.addColumn("Place");
            tableModel.addColumn("Initial");
            tableModel.addColumn("Check");
            Object[] currentRow = new String[]{"", "", ""};
            while (figs.hasMoreElements()) {
                int correctRow;
                Figure fig = (Figure)figs.nextElement();
                if (!(fig instanceof PlaceFigure) || fig instanceof VirtualPlaceFigure) continue;
                String figureName = fileCreator.name((FigureWithID)fig);
                _logger.info((Object)("[Lola] found place named " + figureName));
                currentRow[0] = figureName;
                if (MarkingEditorPanel.this._markingTable.getRowCount() >= tableModel.getRowCount() && (correctRow = MarkingEditorPanel.this.findCorrectRow(currentRow[0], 0)) > -1) {
                    currentRow[2] = (String)MarkingEditorPanel.this._markingTable.getValueAt(correctRow, 2);
                    if (!MarkingEditorPanel.this._updateInitialMarkingCheckbox.isSelected()) {
                        currentRow[1] = (String)MarkingEditorPanel.this._markingTable.getValueAt(correctRow, 1);
                    }
                }
                if (MarkingEditorPanel.this._updateInitialMarkingCheckbox.isSelected()) {
                    HashMap<String, String> markingMap = fileCreator.getInitialMarking(MarkingEditorPanel.this._lolaGUI._drawing);
                    currentRow[1] = markingMap.get(currentRow[0]);
                }
                tableModel.addRow(currentRow);
                _logger.info((Object)("[Lola] adding marking table column " + currentRow.toString()));
            }
            MarkingEditorPanel.this._markingTable.setModel(tableModel);
        }
    }

    class ReachableMarkingAction
    extends AbstractMarkingAction {
        public ReachableMarkingAction() {
            super("Reachability", "reachable");
        }

        @Override
        protected DirectLolaResult checkProperty(File netFile) {
            PropertyAnalyzer analyzer = new PropertyAnalyzer(MarkingEditorPanel.this._lolaGUI._lolaPath);
            String checkMarkingFormula = MarkingEditorPanel.this.getTableMarking(2, 3);
            DirectLolaResult result = analyzer.checkMarkingReachability(checkMarkingFormula, netFile);
            return result;
        }
    }

    class HomeStateMarkingAction
    extends AbstractMarkingAction {
        public HomeStateMarkingAction() {
            super("Home State", "a home state");
        }

        @Override
        protected DirectLolaResult checkProperty(File netFile) {
            PropertyAnalyzer analyzer = new PropertyAnalyzer(MarkingEditorPanel.this._lolaGUI._lolaPath);
            String checkMarkingFormula = MarkingEditorPanel.this.getTableMarking(2, 3);
            DirectLolaResult result = analyzer.checkMarkingHomeState(checkMarkingFormula, netFile);
            return result;
        }
    }

    class CoverableMarkingAction
    extends AbstractMarkingAction {
        public CoverableMarkingAction() {
            super("Coverability", "coverable");
        }

        @Override
        protected DirectLolaResult checkProperty(File netFile) {
            PropertyAnalyzer analyzer = new PropertyAnalyzer(MarkingEditorPanel.this._lolaGUI._lolaPath);
            String checkMarkingFormula = MarkingEditorPanel.this.getTableMarking(2, 2);
            DirectLolaResult result = analyzer.checkMarkingReachability(checkMarkingFormula, netFile);
            return result;
        }
    }

    abstract class AbstractMarkingAction
    implements ActionListener {
        String _property;
        String _adjective;

        protected AbstractMarkingAction(String property, String adjective) {
            this._property = property;
            this._adjective = adjective;
        }

        protected abstract LolaResult checkProperty(File var1);

        @Override
        public void actionPerformed(ActionEvent arg0) {
            DrawApplication app = DrawPlugin.getGui();
            if (app.drawing() instanceof CPNDrawing) {
                MarkingEditorPanel.this._lolaGUI._drawing = (CPNDrawing)app.drawing();
            }
            String initialMarking = MarkingEditorPanel.this.getTableMarking(1, 1);
            String checkMarking = MarkingEditorPanel.this.getTableMarking(2, 1);
            _logger.info((Object)("[Lola] Initial marking from table " + initialMarking.toString()));
            _logger.info((Object)("[Lola] second marking from table " + checkMarking.toString()));
            if (checkMarking.trim() != "MARKING") {
                File tmpLolaFile = new LolaFileCreator().writeTemporaryLolaFile(MarkingEditorPanel.this._lolaGUI._drawing, initialMarking);
                LolaResult result = this.checkProperty(tmpLolaFile);
                LolaResultStatus status = result.getStatus();
                if (status == LolaResultStatus.YES) {
                    JOptionPane.showMessageDialog(MarkingEditorPanel.this, "The marking \n\n" + checkMarking.toString().substring(8) + "\n\nis " + this._adjective + "!", "Lola " + this._property, 1);
                } else if (status == LolaResultStatus.NO) {
                    JOptionPane.showMessageDialog(MarkingEditorPanel.this, "The marking \n\n" + checkMarking.toString().substring(8) + "\n\n<html>is <b>not</b> " + this._adjective + "! </html>", "Lola " + this._property, 0);
                } else {
                    JOptionPane.showMessageDialog(MarkingEditorPanel.this, "The marking \n\n" + checkMarking.toString().substring(8) + "\n\nis not " + this._adjective + " or cannot be computed!", "Lola " + this._property, 2);
                }
            } else {
                _logger.info((Object)("[Lola] No secondary marking input. Cancelling " + this._property + " check!"));
            }
        }
    }
}

