/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.standard.FilteredFigureEnumerator;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.formalism.FormalismPlugin;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.lola2.LolaTask;
import de.renew.lola2.analysis.LolaHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LolaFileCreator {
    private static Logger _logger = Logger.getLogger(LolaFileCreator.class);
    private Map<Figure, String> _usedFigureNames = new HashMap<Figure, String>();
    protected Map<TransitionFigure, HashMap<PlaceFigure, Integer>> _preAll = new HashMap<TransitionFigure, HashMap<PlaceFigure, Integer>>();
    protected Map<TransitionFigure, HashMap<PlaceFigure, Integer>> _postAll = new HashMap<TransitionFigure, HashMap<PlaceFigure, Integer>>();
    private boolean _ptnetcompiler;

    public LolaFileCreator() {
        FormalismPlugin plugin = FormalismPlugin.getCurrent();
        if (plugin != null) {
            String compiler = plugin.getCompiler();
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)("[Lola] Using compiler: " + compiler));
                if (compiler.equals("P/T Net Compiler")) {
                    this._ptnetcompiler = true;
                }
            }
        } else {
            this._ptnetcompiler = true;
        }
    }

    public void writeLolaFile(OutputStream stream, CPNDrawing drawing) {
        this.writeLolaFile(stream, drawing, null);
    }

    public void writeLolaFile(OutputStream stream, CPNDrawing drawing, String initialMarking) {
        if (this.emptyNet(drawing)) {
            _logger.error((Object)"[Lola Export] Net drawing needs at least 1 place and 1 transition.");
            return;
        }
        _logger.info((Object)"[Lola Export] Converting drawing to lola net file format");
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"  Extracting Places");
        }
        StringBuffer placeBuffer = this.extractPlaces(drawing);
        Object marking = initialMarking;
        if (initialMarking == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"  Extracting Marking");
            }
            marking = this.extractMarking(drawing);
        }
        marking = (String)marking + ";\n\n";
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"  Extracting Transitions");
        }
        StringBuffer transitionsBuffer = this.extractTransitions(drawing);
        try {
            stream.write(placeBuffer.toString().getBytes());
            stream.write(((String)marking).getBytes());
            stream.write(transitionsBuffer.toString().getBytes());
        }
        catch (IOException e) {
            _logger.error((Object)"[Lola] Writing to output stream failed");
            e.printStackTrace();
        }
    }

    private boolean emptyNet(CPNDrawing drawing) {
        int p = 0;
        int t = 0;
        FigureEnumeration figs = drawing.figures();
        while (figs.hasMoreElements()) {
            Figure fig = (Figure)figs.nextElement();
            if (fig instanceof PlaceFigure) {
                ++p;
            }
            if (!(fig instanceof TransitionFigure)) continue;
            ++t;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("[Lola] Net " + drawing.getName() + " has " + p + " Places and " + t + " Transitions"));
        }
        return p < 1 || t < 1;
    }

    public File writeTemporaryLolaFile(CPNDrawing drawing) {
        return this.writeTemporaryLolaFile(drawing, null);
    }

    public File writeTemporaryLolaFile(CPNDrawing drawing, String initMarking) {
        File netFile = null;
        FileOutputStream fileStream = null;
        String netName = drawing.getName();
        try {
            netFile = File.createTempFile("renew" + netName, ".net", LolaHelper.findTmpDir());
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)("[Lola] temporay lola net file: " + netFile.getAbsolutePath()));
            }
            fileStream = new FileOutputStream(netFile);
            this.writeLolaFile(fileStream, drawing, initMarking);
        }
        catch (FileNotFoundException e) {
            _logger.error((Object)"[Lola] Could not create stream to write lola file");
            e.printStackTrace();
        }
        catch (IOException e) {
            _logger.error((Object)("[Lola] Could not create temporary lola file in directory " + String.valueOf(LolaHelper.findTmpDir())));
            e.printStackTrace();
        }
        return netFile;
    }

    private StringBuffer extractTransitions(CPNDrawing drawing) {
        StringBuffer buffer = new StringBuffer();
        Boolean check = false;
        FigureEnumeration it = drawing.figures();
        while (it.hasMoreElements()) {
            Figure figure = it.nextFigure();
            if (!(figure instanceof TransitionFigure)) continue;
            TransitionFigure trans = (TransitionFigure)figure;
            buffer.append("TRANSITION " + this.name((FigureWithID)trans) + "{x:" + (int)trans.displayBox().getX() + "y:" + (int)trans.displayBox().getY() + "}\n");
            HashMap<String, Integer> preset = this.preset((Drawing)drawing, trans);
            buffer.append("CONSUME\n  ");
            check = false;
            Iterator<String> iter = preset.keySet().iterator();
            while (iter.hasNext()) {
                if (check.booleanValue()) {
                    buffer.append(",\n  ");
                } else {
                    check = true;
                }
                String placeName = iter.next();
                buffer.append(placeName + ": " + String.valueOf(preset.get(placeName)));
            }
            buffer.append(";\n\n");
            HashMap<String, Integer> postset = this.postset((Drawing)drawing, trans);
            buffer.append("PRODUCE\n  ");
            check = false;
            Iterator<String> iter2 = postset.keySet().iterator();
            while (iter2.hasNext()) {
                if (check.booleanValue()) {
                    buffer.append(",\n  ");
                } else {
                    check = true;
                }
                String placeName = iter2.next();
                buffer.append(placeName + ": " + String.valueOf(postset.get(placeName)));
            }
            buffer.append(";\n\n");
        }
        return buffer;
    }

    private String extractMarking(CPNDrawing drawing) {
        StringBuffer buffer = new StringBuffer();
        Boolean check = false;
        buffer.append("MARKING\n");
        FigureEnumeration iterator = drawing.figures();
        while (iterator.hasMoreElements()) {
            Figure fig = iterator.nextFigure();
            if (!(fig instanceof PlaceFigure)) continue;
            PlaceFigure place = (PlaceFigure)fig;
            if (_logger.isDebugEnabled() && place instanceof VirtualPlaceFigure) {
                _logger.debug((Object)("[Lola Export] Place " + this.name((FigureWithID)place) + " is virtual.\n It is not allowed that both virtual and original place are marked."));
            }
            FigureEnumeration childs = place.children();
            StringBuffer marking = new StringBuffer();
            Boolean hasMarking = false;
            int tokenCounter = 0;
            marking.append(check != false ? ",\n  " : "  ");
            marking.append(place instanceof VirtualPlaceFigure ? this.name(place.getSemanticFigure()) : this.name((FigureWithID)place));
            marking.append(": ");
            while (childs.hasMoreElements()) {
                Figure child = childs.nextFigure();
                if (!(child instanceof CPNTextFigure)) continue;
                String text = ((CPNTextFigure)child).getText();
                if (((CPNTextFigure)child).getType() != 1) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("[Lola Export: Extract Marking] Place " + this.name((FigureWithID)place) + " has inscription " + text));
                }
                if (this._ptnetcompiler) {
                    if (_logger.isInfoEnabled()) {
                        _logger.info((Object)(LolaFileCreator.class.getSimpleName() + ": Encountered ptnetcomp and number: " + text));
                    }
                    tokenCounter = text.matches("^[0-9]*$") ? tokenCounter + Integer.parseInt(text) : tokenCounter + 1;
                } else {
                    ++tokenCounter;
                }
                hasMarking = true;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("[Lola Export: Extract Marking] Place " + this.name((FigureWithID)place) + " has " + tokenCounter + " token."));
            }
            marking.append(tokenCounter);
            if (!hasMarking.booleanValue()) continue;
            check = true;
            buffer.append(marking);
        }
        return buffer.toString();
    }

    private StringBuffer extractPlaces(CPNDrawing drawing) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PLACE\n");
        boolean check = false;
        FigureEnumeration iterator = drawing.figures();
        while (iterator.hasMoreElements()) {
            Figure fig = iterator.nextFigure();
            if (!(fig instanceof PlaceFigure) || fig instanceof VirtualPlaceFigure) continue;
            if (check) {
                buffer.append(",\n");
            } else {
                check = true;
            }
            PlaceFigure place = (PlaceFigure)fig;
            buffer.append("  " + this.name((FigureWithID)place) + "{x:" + (int)place.displayBox().getX() + "y:" + (int)place.displayBox().getY() + "}");
        }
        buffer.append(";\n\n");
        return buffer;
    }

    private HashMap<String, Integer> preset(Drawing drawing, TransitionFigure trans) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        FigureEnumeration iterator = drawing.figures();
        while (iterator.hasMoreElements()) {
            Figure fig = iterator.nextFigure();
            if (!(fig instanceof ArcConnection)) continue;
            ArcConnection arc = (ArcConnection)fig;
            Integer arcType = arc.getArcType();
            Figure end = arc.endFigure();
            Figure start = arc.startFigure();
            if (end.equals(trans) && start instanceof PlaceFigure) {
                String arcSource = this.name((FigureWithID)this.unvirtualize((PlaceFigure)start));
                if (result.get(arcSource) == null) {
                    result.put(arcSource, this.parseArcInscription(arc));
                    continue;
                }
                result.put(arcSource, this.parseArcInscription(arc) + result.get(arcSource));
                continue;
            }
            if (!start.equals(trans) || arcType != 0 && arcType != 2 || !(end instanceof PlaceFigure)) continue;
            String doubleArcDestination = this.name((FigureWithID)this.unvirtualize((PlaceFigure)end));
            if (result.get(doubleArcDestination) == null) {
                result.put(doubleArcDestination, this.parseArcInscription(arc));
                continue;
            }
            result.put(doubleArcDestination, this.parseArcInscription(arc) + result.get(doubleArcDestination));
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("[Lola Export] Preset of " + this.name((FigureWithID)trans) + " is: " + result.toString()));
        }
        return result;
    }

    private PlaceFigure unvirtualize(PlaceFigure fig) {
        return fig instanceof VirtualPlaceFigure ? (PlaceFigure)fig.getSemanticFigure() : fig;
    }

    private Integer parseArcInscription(ArcConnection arc) {
        Integer cardinality = 1;
        boolean check = false;
        int weight = 0;
        FilteredFigureEnumerator textChilds = new FilteredFigureEnumerator(arc.children(), CPNTextFigure::isInscription);
        while (textChilds.hasMoreElements()) {
            check = true;
            Figure child = textChilds.nextFigure();
            String text = ((TextFigure)child).getText();
            if (this._ptnetcompiler) {
                int ret = text.matches("^[0-9]*$") ? Integer.parseInt(text) : 1;
                return ret;
            }
            String[] split = text.split(";");
            String emptyString = "";
            for (String string : split) {
                if (string.equals(emptyString)) continue;
                ++weight;
            }
            if (!_logger.isDebugEnabled()) continue;
            _logger.debug((Object)("[Lola Export] Parsing arc (" + this.name((FigureWithID)arc.startFigure()) + ")--" + text + "-->(" + this.name((FigureWithID)arc.endFigure()) + ")  -- Cardinality is " + cardinality));
        }
        if (check) {
            cardinality = weight;
        }
        return cardinality;
    }

    private HashMap<String, Integer> postset(Drawing drawing, TransitionFigure trans) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        FigureEnumeration iterator = drawing.figures();
        while (iterator.hasMoreElements()) {
            Figure fig = iterator.nextFigure();
            if (!(fig instanceof ArcConnection)) continue;
            ArcConnection arc = (ArcConnection)fig;
            Integer arcType = arc.getArcType();
            Figure end = arc.endFigure();
            Figure start = arc.startFigure();
            if (start.equals(trans) && end instanceof PlaceFigure) {
                String arcDestination = this.name((FigureWithID)this.unvirtualize((PlaceFigure)end));
                if (result.get(arcDestination) == null) {
                    result.put(arcDestination, this.parseArcInscription(arc));
                    continue;
                }
                result.put(arcDestination, this.parseArcInscription(arc) + result.get(arcDestination));
                continue;
            }
            if (!end.equals(trans) || arcType != 0 && arcType != 2 || !(start instanceof PlaceFigure)) continue;
            String doubleArcSource = this.name((FigureWithID)this.unvirtualize((PlaceFigure)start));
            if (result.get(doubleArcSource) == null) {
                result.put(doubleArcSource, this.parseArcInscription(arc));
                continue;
            }
            result.put(doubleArcSource, this.parseArcInscription(arc) + result.get(doubleArcSource));
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("[Lola Export] Postset of " + this.name((FigureWithID)trans) + " is: " + result.toString()));
        }
        return result;
    }

    public String name(FigureWithID figure) {
        StringBuffer retString = new StringBuffer();
        Boolean named = false;
        if (figure instanceof PlaceFigure || figure instanceof TransitionFigure) {
            int id = figure.getID();
            if (this._usedFigureNames.containsKey(figure)) {
                retString.append(this._usedFigureNames.get(figure));
                named = true;
            } else {
                FigureEnumeration childs = ((AttributeFigure)figure).children();
                while (childs.hasMoreElements() && !named.booleanValue()) {
                    Figure child = (Figure)childs.nextElement();
                    if (!(child instanceof CPNTextFigure) || ((CPNTextFigure)child).getType() != 2) continue;
                    Object figureName = ((CPNTextFigure)child).getText();
                    String validName = "^\\p{Alpha}[\\p{Alnum}_-]*[0-9]*\\b";
                    String[] reserved = new String[]{"IF", "RECORD", "END", "SORT", "FUNCTION", "SAFE", "DO", "ARRAY", "STRONG", "WEAK", "FAIR", "ENUMERATE", "CONSTANT", "BOOLEAN", "OF", "BEGIN", "WHILE", "IF", "THEN", "ELSE", "SWITCH", "CASE", "NEXTSTEP", "REPEAT", "FOR", "TO", "ALL", "EXIT", "EXISTS", "RETURN", "TRUE", "FALSE", "MOD", "VAR", "GUARD", "STATE", "PATH", "GENERATOR", "ANALYSE", "PLACE", "TRANSITION", "MARKING", "CONSUME", "PRODUCE", "FORMULA", "EXPATH", "ALLPATH", "ALWAYS", "UNTIL", "EVENTUALLY", "AND", "OR", "NOT"};
                    Boolean notReserved = true;
                    for (String r : reserved) {
                        if (!((String)figureName).equals(r)) continue;
                        notReserved = false;
                        break;
                    }
                    if (((String)figureName).matches(validName) && notReserved.booleanValue()) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug((Object)("[Lola Export] Name of figure seems to be okay: " + (String)figureName));
                        }
                        if (this._usedFigureNames.containsValue(figureName) && this._usedFigureNames.containsValue(figureName = (String)figureName + id)) {
                            _logger.error((Object)("Exception: Name " + (String)figureName + " already exists"));
                        }
                        retString.append((String)figureName);
                        this._usedFigureNames.put((Figure)figure, (String)figureName);
                        named = true;
                        continue;
                    }
                    _logger.error((Object)("[Lola Export] Name " + (String)figureName + " is not valid syntactically."));
                }
            }
            if (!named.booleanValue()) {
                retString.append(figure instanceof PlaceFigure ? "p" : "t");
                retString.append(id);
                if (this._usedFigureNames.containsValue("p" + id) || this._usedFigureNames.containsValue("t" + id)) {
                    retString.append("Exception42");
                }
            }
        }
        return retString.toString();
    }

    public String getNameForFigure(Figure figure) {
        return this._usedFigureNames.get(figure);
    }

    public HashMap<String, String> getInitialMarking(CPNDrawing drawing) {
        HashMap<String, String> result = new HashMap<String, String>();
        String marking = this.extractMarking(drawing).substring(8);
        String[] markingAssignments = marking.split(",");
        try {
            for (String markingAssignment : markingAssignments) {
                String[] split = markingAssignment.split(":");
                String place = split[0].trim();
                String tokens = split[1].trim();
                result.put(place, tokens);
            }
            return result;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            _logger.error((Object)"[Lola] an Index out of bounds exception occurred. Results may be screwed.");
            return result;
        }
    }

    public Vector<LolaTask> parseTasks(CPNDrawing drawing) {
        Vector<LolaTask> result = new Vector<LolaTask>();
        FigureEnumeration figs = drawing.figures();
        while (figs.hasMoreElements()) {
            TextFigure textFig;
            String text;
            Figure fig = (Figure)figs.nextElement();
            if (!(fig instanceof TextFigure) || !(text = (textFig = (TextFigure)fig).getText()).toLowerCase().startsWith("formula")) continue;
            LolaTask tmpTask = new LolaTask((TextFigure)fig, drawing);
            tmpTask.resetColor();
            result.add(tmpTask);
        }
        drawing.checkDamage();
        return result;
    }
}

