/*
 * Decompiled with CFR 0.152.
 */
package de.renew.layoutwindow;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import de.renew.draw.ui.api.CommandApi;
import de.renew.draw.ui.ontology.Alignment;
import de.renew.draw.ui.ontology.SpreadMode;
import de.renew.layoutwindow.AlignCommandActionListener;
import de.renew.layoutwindow.CommandActionListener;
import de.renew.layoutwindow.PositionDimensionsTracker;
import de.renew.windowmanagement.Workbench;
import de.renew.windowmanagement.WorkbenchImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.net.URL;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.text.NumberFormatter;

public class LayoutWindow
extends JPanel {
    private static final String IMAGES = "/de/renew/layoutwindow/images/";
    private static DefaultSingleCDockable _dockable;

    public void init() {
        this.setLayout(new BoxLayout(this, 3));
        Component alignPanel = this.createAlignPanel();
        alignPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)alignPanel.getMinimumSize().getHeight()));
        this.add(alignPanel);
        Component distributePanel = this.createDistributePanel();
        distributePanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)distributePanel.getMinimumSize().getHeight()));
        this.add(distributePanel);
        Component positionDimensionsPanel = this.createPositionDimensionsPanel();
        positionDimensionsPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)positionDimensionsPanel.getMinimumSize().getHeight()));
        this.add(positionDimensionsPanel);
        Component groupUngroup = this.createGroupUngroup();
        groupUngroup.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)groupUngroup.getMinimumSize().getHeight()));
        this.add(groupUngroup);
    }

    private JButton createButton(String label, String relativeIconPath) {
        JButton button;
        String iconPath = IMAGES + relativeIconPath;
        URL o = this.getClass().getResource(iconPath);
        if (o != null) {
            ImageIcon icon = new ImageIcon(o);
            button = new JButton(label, icon);
        } else {
            button = new JButton(label);
        }
        return button;
    }

    private Component createAlignPanel() {
        JPanel alignPanel = new JPanel(new BorderLayout());
        TitledBorder alignBorder = BorderFactory.createTitledBorder("Align");
        alignPanel.setBorder(alignBorder);
        JPanel relativePanel = new JPanel();
        relativePanel.setLayout(new BoxLayout(relativePanel, 2));
        relativePanel.add(new JLabel("Relative to:"));
        String[] listElements = new String[]{"Last selected", "First selected", "Biggest object", "Smallest object", "Selection"};
        JComboBox<String> jComboBox = new JComboBox<String>(listElements);
        relativePanel.add(jComboBox);
        alignPanel.add((Component)relativePanel, "North");
        JPanel alignPanelButtons = new JPanel(new GridLayout(2, 5));
        alignPanel.add((Component)alignPanelButtons, "Center");
        JButton button = this.createButton("Lefts", "align/lefts.gif");
        button.addActionListener(new AlignCommandActionListener("LEFTS", Alignment.LEFTS, jComboBox));
        alignPanelButtons.add(button);
        button = this.createButton("Centers", "align/centers.gif");
        button.addActionListener(new AlignCommandActionListener("CENTERS", Alignment.CENTERS, jComboBox));
        alignPanelButtons.add(button);
        button = this.createButton("Rights", "align/rights.gif");
        button.addActionListener(new AlignCommandActionListener("RIGHTS", Alignment.RIGHTS, jComboBox));
        alignPanelButtons.add(button);
        button = this.createButton("Tops", "align/tops.gif");
        button.addActionListener(new AlignCommandActionListener("TOPS", Alignment.TOPS, jComboBox));
        alignPanelButtons.add(button);
        button = this.createButton("Middles", "align/middles.gif");
        button.addActionListener(new AlignCommandActionListener("MIDDLES", Alignment.MIDDLES, jComboBox));
        alignPanelButtons.add(button);
        button = this.createButton("Bottoms", "align/bottoms.gif");
        button.addActionListener(new AlignCommandActionListener("BOTTOMS", Alignment.BOTTOMS, jComboBox));
        alignPanelButtons.add(button);
        return alignPanel;
    }

    private Component createDistributePanel() {
        JPanel distributePanel = new JPanel();
        distributePanel.setLayout(new BoxLayout(distributePanel, 3));
        TitledBorder distributeBorder = BorderFactory.createTitledBorder("Spread");
        distributePanel.setBorder(distributeBorder);
        JPanel horizontal = new JPanel(new GridLayout(0, 3));
        distributePanel.add(horizontal);
        JPanel vertical = new JPanel(new GridLayout(0, 3));
        distributePanel.add(vertical);
        JPanel diagonal = new JPanel(new GridLayout(0, 3));
        distributePanel.add(diagonal);
        JButton button = this.createButton("Lefts", "spread/lefts.gif");
        button.addActionListener(new CommandActionListener(CommandApi.createSpreadCommand((String)"LEFTS", (SpreadMode)SpreadMode.LEFTS)));
        horizontal.add(button);
        button = this.createButton("Centers", "spread/centers.gif");
        button.addActionListener(new CommandActionListener(CommandApi.createSpreadCommand((String)"CENTERS", (SpreadMode)SpreadMode.CENTERS)));
        horizontal.add(button);
        button = this.createButton("Rights", "spread/rights.gif");
        button.addActionListener(new CommandActionListener(CommandApi.createSpreadCommand((String)"RIGHTS", (SpreadMode)SpreadMode.RIGHTS)));
        horizontal.add(button);
        button = this.createButton("Distances", "spread/distances-lr.gif");
        button.addActionListener(new CommandActionListener(CommandApi.createSpreadCommand((String)"DISTANCES", (SpreadMode)SpreadMode.HORIZONTAL_DISTANCE)));
        horizontal.add(button);
        button = this.createButton("Tops", "spread/tops.gif");
        button.addActionListener(new CommandActionListener(CommandApi.createSpreadCommand((String)"TOPS", (SpreadMode)SpreadMode.TOPS)));
        vertical.add(button);
        button = this.createButton("Middles", "spread/middles.gif");
        button.addActionListener(new CommandActionListener(CommandApi.createSpreadCommand((String)"MIDDLES", (SpreadMode)SpreadMode.MIDDLES)));
        vertical.add(button);
        button = this.createButton("Bottoms", "spread/bottoms.gif");
        button.addActionListener(new CommandActionListener(CommandApi.createSpreadCommand((String)"BOTTOMS", (SpreadMode)SpreadMode.BOTTOMS)));
        vertical.add(button);
        button = this.createButton("Distances", "spread/distances-tb.gif");
        button.addActionListener(new CommandActionListener(CommandApi.createSpreadCommand((String)"DISTANCES", (SpreadMode)SpreadMode.VERTICAL_DISTANCE)));
        vertical.add(button);
        button = this.createButton("Diagonal", "spread/diagonal.gif");
        button.addActionListener(new CommandActionListener(CommandApi.createSpreadCommand((String)"DIAGONAL", (SpreadMode)SpreadMode.DIAGONAL_CENTERS)));
        diagonal.add(button);
        return distributePanel;
    }

    private Component createPositionDimensionsPanel() {
        JPanel positionDimensionsPanel = new JPanel();
        positionDimensionsPanel.setLayout(new BoxLayout(positionDimensionsPanel, 0));
        TitledBorder groupUngroupBorder = BorderFactory.createTitledBorder("Position/Dimensions");
        positionDimensionsPanel.setBorder(groupUngroupBorder);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        intFormat.setGroupingUsed(false);
        NumberFormatter numberFormatter = new NumberFormatter(intFormat);
        JLabel xLabel = new JLabel("x", 4);
        JFormattedTextField xTextField = new JFormattedTextField(numberFormatter);
        positionDimensionsPanel.add(xLabel);
        positionDimensionsPanel.add(xTextField);
        JLabel yLabel = new JLabel("y", 4);
        JFormattedTextField yTextField = new JFormattedTextField(numberFormatter);
        positionDimensionsPanel.add(yLabel);
        positionDimensionsPanel.add(yTextField);
        JLabel widthLabel = new JLabel("width", 4);
        JFormattedTextField widthTextField = new JFormattedTextField(numberFormatter);
        positionDimensionsPanel.add(widthLabel);
        positionDimensionsPanel.add(widthTextField);
        JLabel heightLabel = new JLabel("height", 4);
        JFormattedTextField heightTextField = new JFormattedTextField(numberFormatter);
        positionDimensionsPanel.add(heightLabel);
        positionDimensionsPanel.add(heightTextField);
        new PositionDimensionsTracker(xTextField, yTextField, widthTextField, heightTextField);
        return positionDimensionsPanel;
    }

    private Component createGroupUngroup() {
        JPanel groupUngroupPanel = new JPanel(new GridLayout(1, 3));
        TitledBorder groupUngroupBorder = BorderFactory.createTitledBorder("Group/Ungroup");
        groupUngroupPanel.setBorder(groupUngroupBorder);
        JButton button = this.createButton("Group", "group/group.gif");
        button.addActionListener(new CommandActionListener(CommandApi.createGroupCommand((String)"GROUP")));
        groupUngroupPanel.add(button);
        button = this.createButton("Ungroup", "group/ungroup.gif");
        button.addActionListener(new CommandActionListener(CommandApi.createUnGroupCommand((String)"UNGROUP")));
        groupUngroupPanel.add(button);
        return groupUngroupPanel;
    }

    public static void openLayoutWindow(Workbench workbench) {
        if (_dockable == null) {
            DefaultSingleCDockable layoutWindowDockable = new DefaultSingleCDockable("Layout", new CAction[0]);
            layoutWindowDockable.setTitleText("Layout");
            layoutWindowDockable.setCloseable(true);
            LayoutWindow layoutWindowPanel = new LayoutWindow();
            layoutWindowPanel.init();
            layoutWindowPanel.setVisible(true);
            layoutWindowDockable.add((Component)layoutWindowPanel);
            workbench.addViewWindow(layoutWindowDockable, WorkbenchImpl.UPPER_RIGHT_GROUP);
            _dockable = layoutWindowDockable;
        }
        if (_dockable.isVisible()) {
            _dockable.toFront();
            return;
        }
        _dockable.setVisible(true);
    }
}

