/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import de.uni_hamburg.fs.BasicType;
import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.JavaObject;
import de.uni_hamburg.fs.ListType;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.NullObject;
import de.uni_hamburg.fs.TagMap;
import de.uni_hamburg.fs.Type;

public class PrettyPrinter {
    private TagMap _map;

    private PrettyPrinter(Node node) {
        this._map = new TagMap(node);
    }

    public static void println(FeatureStructure fs) {
        System.out.println(PrettyPrinter.toString(fs));
    }

    public static String toString(FeatureStructure fs) {
        Node node = fs.getRoot();
        return "\n" + new PrettyPrinter(node).toString(node, "\n ", Type.TOP) + "\n";
    }

    private String toString(Node thiz, String indent, Type defaultType) {
        boolean isNode;
        StringBuffer output = new StringBuffer();
        Type nodetype = thiz.getType();
        boolean bl = isNode = (!(nodetype instanceof BasicType) || !((BasicType)nodetype).isObject()) && !(nodetype instanceof NullObject);
        if (isNode) {
            Name tag = this._map.getTag(thiz);
            if (!tag.equals(Name.EMPTY)) {
                output = output.append("#").append(tag._name);
                indent = (String)indent + PrettyPrinter.indent(output.length());
            }
            if (!this._map.visit(thiz)) {
                if (thiz instanceof JavaObject) {
                    output.append(thiz.toString());
                } else {
                    output.append(this.untaggedToString(thiz, (String)indent, defaultType));
                }
            }
        } else {
            output.append(this.untaggedToString(thiz, (String)indent, defaultType));
        }
        return output.toString();
    }

    private String listToString(Node thiz, String indent, Type defaultType) {
        StringBuffer output = new StringBuffer();
        try {
            ListType list = (ListType)thiz.getType();
            Type elemtype = list.getBaseType();
            if (list.getSubtype() == 0) {
                output.append("| ").append(this.toString(thiz, (String)indent + "   ", defaultType));
            } else {
                Type defaultElemType = null;
                defaultElemType = defaultType instanceof ListType ? ((ListType)defaultType).getBaseType() : Type.TOP;
                if (!elemtype.equals(defaultElemType)) {
                    String typename = elemtype.getName();
                    output.append(typename);
                    indent = (String)indent + PrettyPrinter.indent(typename.length());
                }
                if (list.getSubtype() == 1) {
                    output = output.append(this.toString(thiz.delta(ListType.HEAD), (String)indent + " ", elemtype)).append((String)indent);
                    Node tailfs = thiz.delta(ListType.TAIL);
                    Name tag = this._map.getTag(tailfs);
                    Type listtype = tailfs.getType();
                    boolean isTailList = false;
                    if (listtype instanceof ListType) {
                        ListType tailtype = (ListType)tailfs.getType();
                        if (tag.equals(Name.EMPTY) && tailtype.getBaseType().equals(elemtype) || tailtype.getSubtype() == 2) {
                            output = output.append(this.listToString(tailfs, (String)indent, ListType.getList(elemtype)));
                            isTailList = true;
                        }
                    }
                    if (!isTailList) {
                        output = output.append("| ").append(this.toString(tailfs, (String)indent + "   ", ListType.getList(elemtype)));
                    }
                }
            }
        }
        catch (ClassCastException ex) {
            output.append("!!!corrupted list!!!");
        }
        return output.toString();
    }

    private String innerToString(Node thiz, String indent, Type defaultType) {
        StringBuffer output = new StringBuffer();
        String whitespace = "";
        Type nodetype = thiz.getType();
        if (!nodetype.equals(defaultType)) {
            output = output.append(nodetype.getName());
            whitespace = indent;
        }
        CollectionEnumeration features = thiz.featureNames();
        while (features.hasMoreElements()) {
            Name featureName = (Name)features.nextElement();
            String feature = featureName.toString();
            output = output.append(whitespace).append(feature).append(": ").append(this.toString(thiz.delta(featureName), indent + PrettyPrinter.indent(3 + feature.length()), thiz.getType().appropType(featureName)));
            whitespace = indent;
        }
        return output.toString();
    }

    public String untaggedToString(Node thiz, String indent, Type defaultType) {
        StringBuffer output = new StringBuffer();
        Type nodetype = thiz.getType();
        if (nodetype instanceof ListType && ((ListType)nodetype).getSubtype() != 0) {
            output = output.append("<").append(this.listToString(thiz, indent, defaultType)).append(" >");
        } else if (nodetype instanceof BasicType) {
            output.append(this.innerToString(thiz, indent, defaultType));
        } else {
            output.append("[").append(this.innerToString(thiz, indent, defaultType)).append("]");
        }
        return output.toString();
    }

    public static final String indent(int depth) {
        StringBuffer space = new StringBuffer(depth + 1);
        for (int i = 0; i < depth; ++i) {
            space.append(' ');
        }
        return space.toString();
    }
}

