/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import de.renew.util.Null;
import de.renew.util.Types;
import de.renew.util.Value;
import de.uni_hamburg.fs.AbstractNode;
import de.uni_hamburg.fs.BasicType;
import de.uni_hamburg.fs.ConjunctiveType;
import de.uni_hamburg.fs.JavaObject;
import de.uni_hamburg.fs.JavaType;
import de.uni_hamburg.fs.ListNode;
import de.uni_hamburg.fs.ListType;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeSystem;
import de.uni_hamburg.fs.UnificationFailure;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class JavaArrayType
extends ListType
implements JavaType {
    Object[] _javaArray;
    private int _hashCode;
    private AbstractNode _root = null;

    JavaArrayType(Object javaArray) {
        super(TypeSystem.instance().getType(javaArray.getClass().getComponentType()), JavaArrayType.length(javaArray) == 0 ? 2 : 1);
        this._javaArray = JavaArrayType.makeObjectArray(javaArray);
    }

    JavaArrayType(Enumeration<?> enumeration) {
        super(TypeSystem.instance().getType(Object.class), enumeration.hasMoreElements() ? 1 : 2);
        this._javaArray = JavaArrayType.makeObjectArray(enumeration);
    }

    JavaArrayType(Iterator<?> it) {
        super(TypeSystem.instance().getType(Object.class), it.hasNext() ? 1 : 2);
        this._javaArray = JavaArrayType.makeObjectArray(it);
    }

    public static Object[] makeObjectArray(Object array) {
        if (array instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)array;
            Vector elements = new Vector();
            while (enumeration.hasMoreElements()) {
                elements.addElement(enumeration.nextElement());
            }
            Object[] objectArray = new Object[elements.size()];
            elements.copyInto(objectArray);
            return objectArray;
        }
        if (array instanceof Iterator) {
            Iterator it = (Iterator)array;
            ArrayList elements = new ArrayList();
            while (it.hasNext()) {
                elements.add(it.next());
            }
            Object[] objectArray = elements.toArray();
            return objectArray;
        }
        if (array == null || !array.getClass().isArray()) {
            throw new IllegalArgumentException();
        }
        Class<?> clazz = array.getClass().getComponentType();
        if (clazz.isPrimitive()) {
            Object[] objectArray = new Value[JavaArrayType.length(array)];
            for (int i = 0; i < objectArray.length; ++i) {
                Constable val;
                if (clazz == Integer.TYPE) {
                    val = ((int[])array)[i];
                } else if (clazz == Character.TYPE) {
                    val = Character.valueOf(((char[])array)[i]);
                } else if (clazz == Double.TYPE) {
                    val = ((double[])array)[i];
                } else if (clazz == Float.TYPE) {
                    val = Float.valueOf(((float[])array)[i]);
                } else if (clazz == Long.TYPE) {
                    val = ((long[])array)[i];
                } else if (clazz == Byte.TYPE) {
                    val = ((byte[])array)[i];
                } else if (clazz == Boolean.TYPE) {
                    val = Boolean.valueOf(((boolean[])array)[i]);
                } else {
                    throw new RuntimeException("Unknown primitive class: " + String.valueOf(clazz));
                }
                objectArray[i] = new Value((Object)val);
            }
            return objectArray;
        }
        return (Object[])array;
    }

    public static Object makeArray(Object[] objectArray) {
        if (objectArray.length > 0 && objectArray.getClass().getComponentType() == Value.class) {
            Class clazz = Types.typify(((Value)objectArray[0]).value.getClass());
            Object array = Array.newInstance(clazz, objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                Object val = ((Value)objectArray[i]).value;
                if (clazz == Integer.TYPE) {
                    ((int[])array)[i] = (Integer)val;
                    continue;
                }
                if (clazz == Character.TYPE) {
                    ((char[])array)[i] = ((Character)val).charValue();
                    continue;
                }
                if (clazz == Double.TYPE) {
                    ((double[])array)[i] = (Double)val;
                    continue;
                }
                if (clazz == Float.TYPE) {
                    ((float[])array)[i] = ((Float)val).floatValue();
                    continue;
                }
                if (clazz == Long.TYPE) {
                    ((long[])array)[i] = (Long)val;
                    continue;
                }
                if (clazz == Byte.TYPE) {
                    ((byte[])array)[i] = (Byte)val;
                    continue;
                }
                if (clazz == Boolean.TYPE) {
                    ((boolean[])array)[i] = (Boolean)val;
                    continue;
                }
                throw new RuntimeException("Unknown primitive class: " + String.valueOf(clazz));
            }
            return array;
        }
        return objectArray;
    }

    public static int length(Object array) {
        Class<?> clazz = array.getClass().getComponentType();
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return ((int[])array).length;
            }
            if (clazz == Character.TYPE) {
                return ((char[])array).length;
            }
            if (clazz == Double.TYPE) {
                return ((double[])array).length;
            }
            if (clazz == Float.TYPE) {
                return ((float[])array).length;
            }
            if (clazz == Long.TYPE) {
                return ((long[])array).length;
            }
            if (clazz == Byte.TYPE) {
                return ((byte[])array).length;
            }
            if (clazz == Boolean.TYPE) {
                return ((boolean[])array).length;
            }
        }
        return ((Object[])array).length;
    }

    public static boolean equals(Object o1, Object o2) {
        if (Null.nullAwareEquals((Object)o1, (Object)o2)) {
            return true;
        }
        try {
            return JavaArrayType.equals(JavaArrayType.makeObjectArray(o1), JavaArrayType.makeObjectArray(o2));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean equals(Object[] a1, Object[] a2) {
        if (a1.length == a2.length && a1.getClass().getComponentType() == a2.getClass().getComponentType()) {
            for (int i = 0; i < a1.length; ++i) {
                if (Null.nullAwareEquals((Object)a1[i], (Object)a2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof JavaArrayType) {
            JavaArrayType thatJAT = (JavaArrayType)that;
            return JavaArrayType.equals(this._javaArray, thatJAT._javaArray);
        }
        return false;
    }

    @Override
    public boolean isInstanceType() {
        return true;
    }

    @Override
    public Object getJavaObject() {
        return this._javaArray;
    }

    @Override
    public int hashCode() {
        this.buildList();
        return this._hashCode;
    }

    @Override
    public String toString() {
        return BasicType.objToString(this._javaArray);
    }

    @Override
    public boolean subsumes(Type that) {
        return this.equals(that);
    }

    @Override
    public Type unify(Type that) throws UnificationFailure {
        if (that instanceof JavaArrayType) {
            if (this.equals(that)) {
                return this;
            }
        } else if (that instanceof ConjunctiveType) {
            return that.unify(this);
        }
        throw new UnificationFailure();
    }

    @Override
    public boolean canUnify(Type that) {
        try {
            this.unify(that);
            return true;
        }
        catch (UnificationFailure uff) {
            return false;
        }
    }

    @Override
    public Type mostGeneralExtensionalSupertype(Type that) {
        return null;
    }

    private void buildList() {
        if (this._root == null) {
            this._root = (AbstractNode)ListType.getEList(this.getBaseType()).newNode();
            this._hashCode = 0;
            ListType listType = ListType.getNEList(this.getBaseType());
            for (int i = this._javaArray.length - 1; i >= 0; --i) {
                this._hashCode += Null.nullAwareHashCode((Object)this._javaArray[i]);
                AbstractNode tail = this._root;
                this._root = new ListNode(listType);
                this._root.setFeature(ListType.HEAD, JavaObject.getJavaType(this._javaArray[i]).newNode());
                this._root.setFeature(ListType.TAIL, tail);
            }
            this._root._nodetype = this;
            this._hashCode += 3 * this.getBaseType().hashCode();
        }
    }

    @Override
    public Node newNode() {
        this.buildList();
        return this._root;
    }
}

