/*
 * Decompiled with CFR 0.152.
 */
package de.renew.faformalism.compiler;

import de.renew.expression.ConstantExpression;
import de.renew.expression.Expression;
import de.renew.expression.LocalVariable;
import de.renew.expression.VariableExpression;
import de.renew.faformalism.shadow.FAShadowLookupExtension;
import de.renew.faformalism.shadow.ShadowFAArc;
import de.renew.faformalism.shadow.ShadowFAState;
import de.renew.formalism.java.InscriptionParser;
import de.renew.formalism.java.JavaNetHelper;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.SingleJavaNetCompiler;
import de.renew.formalism.java.TypedExpression;
import de.renew.net.ExpressionTokenSource;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.Place;
import de.renew.net.TokenSource;
import de.renew.net.Transition;
import de.renew.net.inscription.TransitionInscription;
import de.renew.net.inscription.arc.Arc;
import de.renew.simulatorontology.shadow.ShadowInscription;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetElement;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.renew.util.Types;
import de.renew.util.Value;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SingleFANetCompiler
extends SingleJavaNetCompiler {
    private static final Logger LOGGER = Logger.getLogger(SingleFANetCompiler.class);
    private static final Value VALUE_ACTIVE = new Value((Object)1);
    private ExpressionTokenSource _tokenSource;
    private static final LocalVariable LETTER = new LocalVariable("a");
    private static final VariableExpression LETTER_EXPR = new VariableExpression(Types.UNTYPED, LETTER);
    public static final String ARC_INSCRIPTION_PATTERN = "action System.out.println(%s);";
    private static int _stateNum = 0;
    private static int _transNum = 0;

    public SingleFANetCompiler() {
        this(false, false, false);
    }

    public SingleFANetCompiler(boolean allowDangerousArcs, boolean allowTimeInscriptions, boolean wantEarlyTokens) {
        super(allowDangerousArcs, allowTimeInscriptions, wantEarlyTokens);
        try {
            this._tokenSource = new ExpressionTokenSource(((TypedExpression)this.parseFAStateInscription("[]").iterator().next()).getExpression());
        }
        catch (SyntaxException e) {
            e.printStackTrace();
        }
    }

    public void compile(ShadowNet shadowNet) throws SyntaxException {
        if (this.hasMultipleStartstates(shadowNet.elements().iterator())) {
            LOGGER.debug((Object)"Found multiple startstate! ~~~~~~~~~~~~~\u00ab\u00ab\u00ab");
            throw new SyntaxException("Cannot simulate automaton with multiple startstates.");
        }
        Net net = this.getLookup().getNet(shadowNet.getName());
        LOGGER.debug((Object)("compile(ShadowNet) compiling " + String.valueOf(net)));
        this.parseDeclarations(shadowNet);
        for (ShadowNetElement elem : shadowNet.elements()) {
            if (!(elem instanceof ShadowFAState)) continue;
            this.compile((ShadowFAState)elem, net);
        }
        LOGGER.debug((Object)"\u00bb~ All shadow states compiled ~\u00ab");
        for (ShadowNetElement elem : shadowNet.elements()) {
            if (!(elem instanceof ShadowFAArc)) continue;
            this.compile((ShadowFAArc)elem, net);
        }
        LOGGER.debug((Object)"\u00bb~ All shadow states compiled ~\u00ab");
        LOGGER.debug((Object)("\u00bb\u00bb~ Compilation of " + shadowNet.getName() + " finished! ~\u00ab\u00ab"));
    }

    protected void compile(ShadowFAState shadowFAState, Net net) throws SyntaxException {
        LOGGER.debug((Object)("compile(ShadowFAState, Net) compiling " + String.valueOf((Object)shadowFAState)));
        Object sname = shadowFAState.getName();
        if (sname == null) {
            sname = "State" + ++_stateNum;
        }
        Place place = new Place(net, (String)sname, new NetElementID(shadowFAState.getID()));
        place.setTrace(shadowFAState.getTrace());
        if (shadowFAState._stateType == 1 || shadowFAState._stateType == 3) {
            place.add((TokenSource)this._tokenSource);
        }
        FAShadowLookupExtension.lookup(this.lookup).set(shadowFAState, place);
        this.compileFAStateInscriptions(shadowFAState, place);
    }

    protected void compile(ShadowFAArc shadowFAArc, Net net) throws SyntaxException {
        LOGGER.debug((Object)("compile(ShadowFAArc, Net) compiling " + String.valueOf((Object)shadowFAArc)));
        LOGGER.debug((Object)("ShadowFAArcs name is " + shadowFAArc.getName()));
        Object tname = shadowFAArc.toString();
        if (tname == null) {
            tname = "Arc" + ++_transNum;
        }
        Transition transition = new Transition(net, (String)tname, new NetElementID(shadowFAArc.getID()));
        FAShadowLookupExtension.lookup(this.lookup).set(shadowFAArc, transition);
        Place src = FAShadowLookupExtension.lookup(this.lookup).get(shadowFAArc._src);
        Arc arc = new Arc(src, transition, Arc.Type.IN, (Expression)LETTER_EXPR, ConstantExpression.DOUBLE_ZERO_EXPRESSION);
        arc.setTrace(shadowFAArc.getTrace());
        transition.add((TransitionInscription)arc);
        Place dest = FAShadowLookupExtension.lookup(this.lookup).get(shadowFAArc._dest);
        arc = new Arc(dest, transition, Arc.Type.OUT, (Expression)LETTER_EXPR, ConstantExpression.DOUBLE_ZERO_EXPRESSION);
        arc.setTrace(shadowFAArc.getTrace());
        transition.add((TransitionInscription)arc);
        this.compileFAArcInscriptions(shadowFAArc);
    }

    protected void compileFAStateInscriptions(ShadowFAState shadowFAState, Place place) throws SyntaxException {
        LOGGER.debug((Object)("compileFAStateInscriptions(ShadowFAState, Place) called with " + String.valueOf((Object)shadowFAState) + " and " + String.valueOf(place)));
        for (ShadowNetElement elem : shadowFAState.elements()) {
            LOGGER.debug((Object)(String.valueOf((Object)this) + " has " + String.valueOf(elem) + " as child"));
            if (elem instanceof ShadowInscription) {
                String inscr = ((ShadowInscription)elem).getInscription();
                try {
                    for (Object expr : this.parseFAStateInscription(inscr)) {
                        if (!(expr instanceof TypedExpression)) continue;
                        TypedExpression typedExpr = (TypedExpression)expr;
                        Expression castedExpression = null;
                        try {
                            castedExpression = JavaNetHelper.makeCastedOutputExpression((Class)Types.UNTYPED, (TypedExpression)typedExpr);
                        }
                        catch (SyntaxException e) {
                            throw e.addObject((Object)elem);
                        }
                        place.add((TokenSource)new ExpressionTokenSource(castedExpression));
                        LOGGER.debug((Object)("Added " + String.valueOf(castedExpression) + " to " + String.valueOf((Object)shadowFAState)));
                    }
                    continue;
                }
                catch (SyntaxException e) {
                    throw e.addObject((Object)elem);
                }
            }
            if (elem instanceof ShadowFAArc) continue;
            throw new SyntaxException("Unsupported place inscription: " + String.valueOf(elem.getClass())).addObject((Object)shadowFAState).addObject((Object)elem);
        }
    }

    private Collection<Object> parseFAStateInscription(String inscr) throws SyntaxException {
        LOGGER.debug((Object)("parseFAStateInscription(String) called with " + inscr));
        if (inscr != null && !inscr.equals("")) {
            LOGGER.debug((Object)("FAState has inscription \u00bb " + inscr + " \u00ab"));
            InscriptionParser parser = this.makeParser(inscr);
            parser.setDeclarationNode(this.declaration);
            try {
                return parser.PlaceInscription();
            }
            catch (ParseException e) {
                throw SingleFANetCompiler.makeSyntaxException((ParseException)e);
            }
        }
        return Collections.emptySet();
    }

    protected void compileFAArcInscriptions(ShadowFAArc shadowFAArc) throws SyntaxException {
        LOGGER.debug((Object)("compileFAArcInscriptions(ShadowFAArc) called with " + String.valueOf((Object)shadowFAArc)));
        Vector<TransitionInscription> parsedInscriptions = new Vector<TransitionInscription>();
        Iterator inscriptions = shadowFAArc.elements().iterator();
        Transition faArcTrans = FAShadowLookupExtension.lookup(this.lookup).get(shadowFAArc);
        while (inscriptions.hasNext()) {
            Object elem = inscriptions.next();
            if (!(elem instanceof ShadowInscription)) continue;
            ShadowInscription inscription = (ShadowInscription)elem;
            parsedInscriptions.addAll(this.parseFAArcInscription(inscription, faArcTrans));
        }
        for (TransitionInscription transInscr : parsedInscriptions) {
            faArcTrans.add(transInscr);
        }
    }

    private Collection<TransitionInscription> parseFAArcInscription(ShadowInscription inscription, Transition transition) throws SyntaxException {
        LOGGER.debug((Object)("parseFAArcInscription(ShadowInscription, Transition) called with " + String.valueOf(inscription) + " and " + String.valueOf(transition)));
        String inscrType = this.checkTransitionInscription(inscription.getInscription(), false, inscription.getNet());
        LOGGER.debug((Object)("Parsed inscription was \u00bb " + inscrType + " \u00ab"));
        return this.makeInscriptions(inscription.getInscription(), transition, true);
    }

    private boolean hasMultipleStartstates(Iterator<ShadowNetElement> shadowNetElements) {
        int startstateCount = 0;
        while (shadowNetElements.hasNext()) {
            ShadowNetElement elem = shadowNetElements.next();
            if (!(elem instanceof ShadowFAState)) continue;
            ShadowFAState shFAState = (ShadowFAState)elem;
            if (shFAState._stateType != 1 && shFAState._stateType != 3 || ++startstateCount <= 1) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

