/*
 * Decompiled with CFR 0.152.
 */
package de.renew.faformalism;

import de.renew.faformalism.compiler.FAAutomatonCompiler;
import de.renew.faformalism.compiler.FANetCompiler;
import de.renew.formalism.FormalismPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.shadowcompiler.ShadowCompilerFactory;
import java.net.URL;
import org.apache.log4j.Logger;

public class FAFormalismPlugin
extends PluginAdapter {
    private static final Logger LOGGER = Logger.getLogger(FAFormalismPlugin.class);
    public static final String FA_NET_COMPILER_NAME = "FA Net Compiler";
    public static final String FA_AUTOMATON_COMPILER_NAME = "FA Automaton Compiler";

    public FAFormalismPlugin(URL url) throws PluginException {
        super(url);
    }

    public FAFormalismPlugin(PluginProperties props) {
        super(props);
    }

    public void init() {
        FormalismPlugin fp = FormalismPlugin.getCurrent();
        if (fp != null) {
            fp.addCompilerFactory(FA_NET_COMPILER_NAME, (ShadowCompilerFactory)new FANetCompiler());
            fp.addCompilerFactory(FA_AUTOMATON_COMPILER_NAME, (ShadowCompilerFactory)new FAAutomatonCompiler());
        }
        LOGGER.debug((Object)"FA Compiler factories added");
    }

    public boolean cleanup() {
        FormalismPlugin fp = FormalismPlugin.getCurrent();
        if (fp != null) {
            fp.removeCompilerFactory(FA_NET_COMPILER_NAME);
            fp.removeCompilerFactory(FA_AUTOMATON_COMPILER_NAME);
        }
        return super.cleanup();
    }
}

