/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words;

import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.automatalib.AutomataLibProperty;
import net.automatalib.AutomataLibSettings;
import net.automatalib.commons.smartcollections.ArrayWritable;
import net.automatalib.commons.util.array.AWUtil;
import net.automatalib.commons.util.strings.AbstractPrintable;
import net.automatalib.words.Alphabet;
import net.automatalib.words.CanonicalWordComparator;
import net.automatalib.words.EmptyWord;
import net.automatalib.words.LetterWord;
import net.automatalib.words.SharedWord;
import net.automatalib.words.SubwordList;
import net.automatalib.words.WordCollector;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Word<I>
extends AbstractPrintable
implements ArrayWritable<I>,
Iterable<I>,
Serializable {
    private static final String EMPTY_WORD_REP;
    private static final String WORD_DELIM_LEFT;
    private static final String WORD_DELIM_RIGHT;
    private static final String WORD_SYMBOL_SEPARATOR;
    private static final String WORD_SYMBOL_DELIM_LEFT;
    private static final String WORD_SYMBOL_DELIM_RIGHT;

    public static <I> Comparator<Word<I>> canonicalComparator(Comparator<? super I> symComparator) {
        return new CanonicalWordComparator<I>(symComparator);
    }

    @SafeVarargs
    public static <I> Word<I> fromSymbols(I ... symbols) {
        if (symbols.length == 0) {
            return Word.epsilon();
        }
        if (symbols.length == 1) {
            return Word.fromLetter(symbols[0]);
        }
        return new SharedWord((Object[])symbols.clone());
    }

    public static <I> Word<I> epsilon() {
        return EmptyWord.INSTANCE;
    }

    public static <I> Word<I> fromLetter(I letter) {
        return new LetterWord<I>(letter);
    }

    public static <I> Word<I> fromArray(I[] symbols, int offset, int length) {
        if (length == 0) {
            return Word.epsilon();
        }
        if (length == 1) {
            return Word.fromLetter(symbols[offset]);
        }
        Object[] array = new Object[length];
        System.arraycopy(symbols, offset, array, 0, length);
        return new SharedWord(array);
    }

    public static <I> Word<I> fromList(List<? extends I> symbolList) {
        int siz = symbolList.size();
        if (siz == 0) {
            return Word.epsilon();
        }
        if (siz == 1) {
            return Word.fromLetter(symbolList.get(0));
        }
        return new SharedWord<I>(symbolList);
    }

    public static Word<Character> fromString(String str) {
        return Word.fromCharSequence(str);
    }

    public static Word<Character> fromCharSequence(CharSequence cs) {
        int len = cs.length();
        Object[] chars = new Character[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = Character.valueOf(cs.charAt(i));
        }
        return new SharedWord<Character>(chars);
    }

    @SafeVarargs
    public static <I> Word<I> fromWords(Word<? extends I> ... words) {
        return Word.fromWords(Arrays.asList(words));
    }

    public static <I> Word<I> fromWords(Collection<? extends Word<? extends I>> words) {
        int totalLength = 0;
        for (Word<I> w : words) {
            totalLength += w.length();
        }
        if (totalLength == 0) {
            return Word.epsilon();
        }
        Object[] array = new Object[totalLength];
        int currOfs = 0;
        for (Word<I> w : words) {
            AWUtil.safeWrite(w, array, currOfs);
            currOfs += w.length();
        }
        return new SharedWord(array);
    }

    public abstract int length();

    public static <I> Word<I> upcast(Word<? extends I> word) {
        return word;
    }

    public int hashCode() {
        int hash = 5;
        for (I sym : this) {
            hash *= 89;
            hash += sym != null ? sym.hashCode() : 0;
        }
        return hash;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Word)) {
            return false;
        }
        Word otherWord = (Word)other;
        int len = otherWord.length();
        if (len != this.length()) {
            return false;
        }
        java.util.Iterator<I> thisIt = this.iterator();
        java.util.Iterator<I> otherIt = otherWord.iterator();
        while (thisIt.hasNext()) {
            I otherSym;
            I thisSym = thisIt.next();
            if (Objects.equals(thisSym, otherSym = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public java.util.Iterator<I> iterator() {
        return new Iterator();
    }

    @Override
    public Spliterator<I> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 17424);
    }

    @Override
    public void print(Appendable a) throws IOException {
        if (this.isEmpty()) {
            a.append(EMPTY_WORD_REP);
        } else {
            a.append(WORD_DELIM_LEFT);
            java.util.Iterator<I> symIt = this.iterator();
            assert (symIt.hasNext());
            Word.appendSymbol(a, symIt.next());
            while (symIt.hasNext()) {
                a.append(WORD_SYMBOL_SEPARATOR);
                Word.appendSymbol(a, symIt.next());
            }
            a.append(WORD_DELIM_RIGHT);
        }
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    private static void appendSymbol(Appendable a, @Nullable Object symbol) throws IOException {
        a.append(WORD_SYMBOL_DELIM_LEFT);
        a.append(String.valueOf(symbol));
        a.append(WORD_SYMBOL_DELIM_RIGHT);
    }

    public Stream<I> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<I> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    public final Word<I> subWord(int fromIndex) {
        if (fromIndex <= 0) {
            if (fromIndex == 0) {
                return this;
            }
            throw new IndexOutOfBoundsException("Invalid subword range [" + fromIndex + ",)");
        }
        return this.subWordInternal(fromIndex, this.length());
    }

    public final Word<I> subWord(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex < fromIndex || toIndex > this.length()) {
            throw new IndexOutOfBoundsException("Invalid subword range [" + fromIndex + ", " + toIndex + ")");
        }
        return this.subWordInternal(fromIndex, toIndex);
    }

    protected Word<I> subWordInternal(int fromIndex, int toIndex) {
        int len = toIndex - fromIndex;
        Object[] array = new Object[len];
        this.writeToArray(fromIndex, array, 0, len);
        return new SharedWord(array);
    }

    @Override
    public void writeToArray(int offset, @Nullable Object[] array, int tgtOffset, int length) {
        int idx = offset;
        int arrayIdx = tgtOffset;
        for (int i = length; i > 0; --i) {
            array[arrayIdx++] = this.getSymbol(idx++);
        }
    }

    public abstract I getSymbol(int var1);

    @Override
    public final int size() {
        return this.length();
    }

    public List<I> asList() {
        return new AsList();
    }

    public List<Word<I>> prefixes(boolean longestFirst) {
        return new SubwordList(this, true, longestFirst);
    }

    public List<Word<I>> suffixes(boolean longestFirst) {
        return new SubwordList(this, false, longestFirst);
    }

    public Word<I> canonicalNext(Alphabet<I> sigma) {
        int len = this.length();
        @Nullable Object[] symbols = new Object[len];
        this.writeToArray(0, symbols, 0, len);
        int alphabetSize = sigma.size();
        int i = 0;
        boolean overflow = true;
        for (I sym : this) {
            int nextIdx = (sigma.getSymbolIndex(sym) + 1) % alphabetSize;
            symbols[i++] = sigma.getSymbol(nextIdx);
            if (nextIdx == 0) continue;
            overflow = false;
            break;
        }
        while (i < len) {
            symbols[i] = this.getSymbol(i);
            ++i;
        }
        if (overflow) {
            @Nullable Object[] newSymbols = new Object[len + 1];
            newSymbols[0] = sigma.getSymbol(0);
            System.arraycopy(symbols, 0, newSymbols, 1, len);
            symbols = newSymbols;
        }
        return new SharedWord(symbols);
    }

    public I lastSymbol() {
        return this.getSymbol(this.length() - 1);
    }

    public I firstSymbol() {
        return this.getSymbol(0);
    }

    public Word<I> append(I symbol) {
        int len = this.length();
        @Nullable Object[] array = new Object[len + 1];
        this.writeToArray(0, array, 0, len);
        array[len] = symbol;
        return new SharedWord(array);
    }

    public Word<I> prepend(I symbol) {
        int len = this.length();
        @Nullable Object[] array = new Object[len + 1];
        array[0] = symbol;
        this.writeToArray(0, array, 1, len);
        return new SharedWord(array);
    }

    @SafeVarargs
    public final Word<I> concat(Word<? extends I> ... words) {
        return this.concatInternal(words);
    }

    protected Word<I> concatInternal(Word<? extends I> ... words) {
        int len;
        if (words.length == 0) {
            return this;
        }
        int totalSize = len = this.length();
        for (Word<I> word : words) {
            totalSize += word.length();
        }
        Object[] array = new Object[totalSize];
        this.writeToArray(0, array, 0, len);
        int currOfs = len;
        for (Word<I> word : words) {
            int wLen = word.length();
            word.writeToArray(0, array, currOfs, wLen);
            currOfs += wLen;
        }
        return new SharedWord(array);
    }

    public boolean isPrefixOf(Word<?> other) {
        int len = this.length();
        int otherLen = other.length();
        if (otherLen < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            Object sym2;
            I sym1 = this.getSymbol(i);
            if (Objects.equals(sym1, sym2 = other.getSymbol(i))) continue;
            return false;
        }
        return true;
    }

    public Word<I> longestCommonPrefix(Word<?> other) {
        Object sym2;
        I sym1;
        int i;
        int len = this.length();
        int otherLen = other.length();
        int maxIdx = Math.min(len, otherLen);
        for (i = 0; i < maxIdx && Objects.equals(sym1 = this.getSymbol(i), sym2 = other.getSymbol(i)); ++i) {
        }
        return this.prefix(i);
    }

    public final Word<I> prefix(int prefixLen) {
        int length = prefixLen < 0 ? this.length() + prefixLen : prefixLen;
        return this.subWord(0, length);
    }

    public boolean isSuffixOf(Word<?> other) {
        int len = this.length();
        int otherLen = other.length();
        if (otherLen < len) {
            return false;
        }
        int ofs = otherLen - len;
        for (int i = 0; i < len; ++i) {
            Object sym2;
            I sym1 = this.getSymbol(i);
            if (Objects.equals(sym1, sym2 = other.getSymbol(ofs + i))) continue;
            return false;
        }
        return true;
    }

    public Word<I> longestCommonSuffix(Word<?> other) {
        Object sym2;
        I sym1;
        int i;
        int len = this.length();
        int otherLen = other.length();
        int minLen = Math.min(len, otherLen);
        int idx1 = len;
        int idx2 = otherLen;
        for (i = 0; i < minLen && Objects.equals(sym1 = this.getSymbol(--idx1), sym2 = other.getSymbol(--idx2)); ++i) {
        }
        return this.suffix(i);
    }

    public final Word<I> suffix(int suffixLen) {
        int wordLen = this.length();
        int startIdx = suffixLen < 0 ? -suffixLen : wordLen - suffixLen;
        return this.subWord(startIdx, wordLen);
    }

    public Word<I> flatten() {
        int len = this.length();
        Object[] array = new Object[len];
        this.writeToArray(0, array, 0, len);
        return new SharedWord(array);
    }

    public Word<I> trimmed() {
        int len = this.length();
        Object[] array = new Object[len];
        this.writeToArray(0, array, 0, len);
        return new SharedWord(array);
    }

    public int[] toIntArray(ToIntFunction<? super I> toInt) {
        int len = this.length();
        int[] result = new int[len];
        int i = 0;
        for (I sym : this) {
            int symIdx = toInt.applyAsInt(sym);
            result[i++] = symIdx;
        }
        return result;
    }

    public <T> Word<T> transform(Function<? super I, ? extends T> transformer) {
        int len = this.length();
        @Nullable Object[] array = new Object[len];
        int i = 0;
        for (I symbol : this) {
            array[i++] = transformer.apply(symbol);
        }
        return new SharedWord(array);
    }

    public static <I> Collector<I, ?, Word<I>> collector() {
        return new WordCollector();
    }

    static {
        AutomataLibSettings settings = AutomataLibSettings.getInstance();
        EMPTY_WORD_REP = settings.getProperty(AutomataLibProperty.WORD_EMPTY_REP, "\u03b5");
        WORD_DELIM_LEFT = settings.getProperty(AutomataLibProperty.WORD_DELIM_LEFT, "");
        WORD_DELIM_RIGHT = settings.getProperty(AutomataLibProperty.WORD_DELIM_RIGHT, "");
        WORD_SYMBOL_SEPARATOR = settings.getProperty(AutomataLibProperty.WORD_SYMBOL_SEPARATOR, " ");
        WORD_SYMBOL_DELIM_LEFT = settings.getProperty(AutomataLibProperty.WORD_SYMBOL_DELIM_LEFT, "");
        WORD_SYMBOL_DELIM_RIGHT = settings.getProperty(AutomataLibProperty.WORD_SYMBOL_DELIM_RIGHT, "");
    }

    private class AsList
    extends AbstractList<I> {
        private AsList() {
        }

        @Override
        public I get(int index) {
            return Word.this.getSymbol(index);
        }

        @Override
        public java.util.Iterator<I> iterator() {
            return Word.this.iterator();
        }

        @Override
        public int size() {
            return Word.this.length();
        }
    }

    private class Iterator
    implements java.util.Iterator<I> {
        private int index;

        private Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < Word.this.length();
        }

        @Override
        public I next() {
            if (this.index >= Word.this.length()) {
                throw new NoSuchElementException();
            }
            return Word.this.getSymbol(this.index++);
        }
    }
}

