/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.tries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.automatalib.graphs.Graph;
import net.automatalib.util.tries.SuffixTrieNode;
import net.automatalib.visualization.DefaultVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SuffixTrie<I>
implements Graph<SuffixTrieNode<I>, SuffixTrieNode<I>> {
    public static final boolean DEFAULT_GRAPH_REPRESENTABLE = true;
    protected final SuffixTrieNode<I> root;
    protected final @Nullable List<SuffixTrieNode<I>> nodes;

    public SuffixTrie() {
        this(true);
    }

    public SuffixTrie(boolean graphRepresentable) {
        this(graphRepresentable, new SuffixTrieNode());
    }

    protected SuffixTrie(boolean graphRepresentable, SuffixTrieNode<I> root) {
        this.root = root;
        if (graphRepresentable) {
            this.nodes = new ArrayList<SuffixTrieNode<I>>();
            this.nodes.add(root);
        } else {
            this.nodes = null;
        }
    }

    protected SuffixTrie(SuffixTrieNode<I> root) {
        this(true, root);
    }

    @Override
    public Collection<SuffixTrieNode<I>> getNodes() {
        if (this.nodes == null) {
            throw new UnsupportedOperationException("This trie is not graph representable");
        }
        return Collections.unmodifiableCollection(this.nodes);
    }

    @Override
    public Collection<SuffixTrieNode<I>> getOutgoingEdges(SuffixTrieNode<I> node) {
        if (this.nodes == null) {
            throw new UnsupportedOperationException("This trie is not graph representable");
        }
        SuffixTrieNode<I> parent = node.getParent();
        if (parent == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(parent);
    }

    @Override
    public SuffixTrieNode<I> getTarget(SuffixTrieNode<I> edge) {
        if (this.nodes == null) {
            throw new UnsupportedOperationException("This trie is not graph representable");
        }
        return edge;
    }

    @Override
    public VisualizationHelper<SuffixTrieNode<I>, SuffixTrieNode<I>> getVisualizationHelper() {
        if (this.nodes == null) {
            throw new UnsupportedOperationException("This trie is not graph representable");
        }
        return new DefaultVisualizationHelper<SuffixTrieNode<I>, SuffixTrieNode<I>>(){

            @Override
            public boolean getNodeProperties(SuffixTrieNode<I> node, Map<String, String> properties) {
                if (!super.getNodeProperties(node, properties)) {
                    return false;
                }
                String lbl = node.isRoot() ? "\u03b5" : String.valueOf(node.getSymbol());
                properties.put("label", lbl);
                return true;
            }
        };
    }

    public SuffixTrieNode<I> add(I symbol, SuffixTrieNode<I> parent) {
        SuffixTrieNode<I> n = new SuffixTrieNode<I>(symbol, parent);
        if (this.nodes != null) {
            this.nodes.add(n);
        }
        return n;
    }

    public SuffixTrieNode<I> getRoot() {
        return this.root;
    }
}

