/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.minimizer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.automatalib.graphs.UniversalIndefiniteGraph;
import net.automatalib.util.minimizer.Block;
import net.automatalib.util.minimizer.InitialPartitioning;
import org.checkerframework.checker.nullness.qual.Nullable;

class HashMapInitialPartitioning<S, L>
implements InitialPartitioning<S, L> {
    private final Map<@Nullable Object, Block<S, L>> initialBlockMap = new HashMap<Object, Block<S, L>>();
    private final UniversalIndefiniteGraph<S, ?, ?, L> graph;
    private int numExistingBlocks;

    HashMapInitialPartitioning(UniversalIndefiniteGraph<S, ?, ?, L> graph) {
        this.graph = graph;
    }

    @Override
    public Block<S, L> getBlock(S origState) {
        @Nullable ? clazz = this.graph.getNodeProperty(origState);
        return this.initialBlockMap.computeIfAbsent(clazz, k -> new Block(this.numExistingBlocks++));
    }

    @Override
    public Collection<Block<S, L>> getInitialBlocks() {
        return this.initialBlockMap.values();
    }
}

