/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.predicates;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import net.automatalib.automata.concepts.TransitionOutput;
import net.automatalib.commons.util.functions.FunctionsUtil;
import net.automatalib.ts.TransitionPredicate;
import net.automatalib.util.automata.predicates.OutputSatisfies;

public final class TransitionPredicates {
    private TransitionPredicates() {
    }

    public static <S, I, T> TransitionPredicate<S, I, T> safePred(TransitionPredicate<S, I, T> pred, boolean nullValue) {
        if (pred != null) {
            return pred;
        }
        return (s2, i, t) -> nullValue;
    }

    public static <S, I, T> TransitionPredicate<S, I, T> compose(Predicate<? super S> sourcePred, Predicate<? super I> inputPred, Predicate<? super T> transPred) {
        Predicate safeSource = FunctionsUtil.safeToTrue(sourcePred);
        Predicate safeInput = FunctionsUtil.safeToTrue(inputPred);
        Predicate safeTrans = FunctionsUtil.safeToTrue(transPred);
        return (s2, i, t) -> safeSource.test((Object)s2) && safeInput.test((Object)i) && safeTrans.test(t);
    }

    public static <S, I, T> TransitionPredicate<S, I, T> alwaysTrue() {
        return (s2, i, t) -> true;
    }

    public static <S, I, T> TransitionPredicate<S, I, T> alwaysFalse() {
        return (s2, i, t) -> false;
    }

    public static <S, I, T> TransitionPredicate<S, I, T> constantValue(boolean value) {
        return (s2, i, t) -> value;
    }

    public static <S, I, T> TransitionPredicate<S, I, T> sourceSatisfying(Predicate<? super S> sourcePred) {
        return (s2, i, t) -> sourcePred.test((Object)s2);
    }

    public static <S, I, T> TransitionPredicate<S, I, T> inputSatisfying(Predicate<? super I> inputPred) {
        return (s2, i, t) -> inputPred.test((Object)i);
    }

    public static <S, I, T> TransitionPredicate<S, I, T> transitionSatisfying(Predicate<? super T> transPred) {
        return (s2, i, t) -> transPred.test(t);
    }

    public static <S, I, T> TransitionPredicate<S, I, T> inputIs(Object input) {
        return (s2, i, t) -> Objects.equals(i, input);
    }

    public static <S, I, T> TransitionPredicate<S, I, T> inputIsNot(Object input) {
        return (s2, i, t) -> !Objects.equals(i, input);
    }

    @SafeVarargs
    public static <S, I, T> TransitionPredicate<S, I, T> inputIn(Object ... inputs) {
        return TransitionPredicates.inputIn(Arrays.asList(inputs));
    }

    public static <S, I, T> TransitionPredicate<S, I, T> inputIn(Collection<?> inputs) {
        return (s2, i, t) -> inputs.contains(i);
    }

    @SafeVarargs
    public static <S, I, T> TransitionPredicate<S, I, T> inputNotIn(Object ... inputs) {
        return TransitionPredicates.inputNotIn(Arrays.asList(inputs));
    }

    public static <S, I, T> TransitionPredicate<S, I, T> inputNotIn(Collection<?> inputs) {
        return (s2, i, t) -> !inputs.contains(i);
    }

    public static <S, I, T> TransitionPredicate<S, I, T> outputIs(TransitionOutput<? super T, ?> transOut, Object output) {
        return TransitionPredicates.outputSatisfies(transOut, o -> Objects.equals(o, output));
    }

    public static <S, I, T, O> TransitionPredicate<S, I, T> outputSatisfies(TransitionOutput<? super T, ? extends O> transOut, Predicate<? super O> outputPred) {
        return new OutputSatisfies(transOut, outputPred);
    }

    public static <S, I, T> TransitionPredicate<S, I, T> outputIsNot(TransitionOutput<? super T, ?> transOut, Object output) {
        return TransitionPredicates.outputViolates(transOut, o -> Objects.equals(o, output));
    }

    public static <S, I, T, O> TransitionPredicate<S, I, T> outputViolates(TransitionOutput<? super T, ? extends O> transOut, Predicate<? super O> outputPred) {
        return new OutputSatisfies(transOut, outputPred, true);
    }

    public static <S, I, T> TransitionPredicate<S, I, T> outputIn(TransitionOutput<? super T, ?> transOut, Object ... outputs) {
        return TransitionPredicates.outputIn(transOut, Arrays.asList(outputs));
    }

    public static <S, I, T> TransitionPredicate<S, I, T> outputIn(TransitionOutput<? super T, ?> transOut, Collection<?> outputs) {
        return TransitionPredicates.outputSatisfies(transOut, outputs::contains);
    }

    public static <S, I, T> TransitionPredicate<S, I, T> outputNotIn(TransitionOutput<? super T, ?> transOut, Object ... outputs) {
        return TransitionPredicates.outputNotIn(transOut, Arrays.asList(outputs));
    }

    public static <S, I, T> TransitionPredicate<S, I, T> outputNotIn(TransitionOutput<? super T, ?> transOut, Collection<?> outputs) {
        return TransitionPredicates.outputViolates(transOut, outputs::contains);
    }
}

